/*
 * Decompiled with CFR 0.152.
 */
package io.flamingock.oss.driver.mongodb.sync.v4.internal.mongodb;

import com.mongodb.client.MongoCollection;
import com.mongodb.client.model.IndexOptions;
import io.flamingock.oss.driver.common.mongodb.CollectionWrapper;
import io.flamingock.oss.driver.common.mongodb.DocumentWrapper;
import io.flamingock.oss.driver.mongodb.sync.v4.internal.mongodb.MongoSync4DocumentWrapper;
import org.bson.Document;
import org.bson.conversions.Bson;

public class MongoSync4CollectionWrapper
implements CollectionWrapper<MongoSync4DocumentWrapper> {
    private final MongoCollection<Document> collection;

    public MongoSync4CollectionWrapper(MongoCollection<Document> collection) {
        this.collection = collection;
    }

    public String getCollectionName() {
        return this.collection.getNamespace().getCollectionName();
    }

    public Iterable<DocumentWrapper> listIndexes() {
        return this.collection.listIndexes().map(MongoSync4DocumentWrapper::new);
    }

    public String createUniqueIndex(MongoSync4DocumentWrapper uniqueIndexDocument) {
        return this.collection.createIndex((Bson)uniqueIndexDocument.getDocument(), new IndexOptions().unique(true));
    }

    public void dropIndex(String indexName) {
        this.collection.dropIndex(indexName);
    }

    public void deleteMany(MongoSync4DocumentWrapper documentWrapper) {
        this.collection.deleteMany((Bson)documentWrapper.getDocument());
    }
}

