/*
 * Decompiled with CFR 0.152.
 */
package io.flamingock.oss.driver.mongodb.sync.v4.internal;

import com.mongodb.DuplicateKeyException;
import com.mongodb.ErrorCategory;
import com.mongodb.MongoWriteException;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoDatabase;
import com.mongodb.client.model.Filters;
import com.mongodb.client.model.UpdateOptions;
import com.mongodb.client.result.UpdateResult;
import io.flamingock.commons.utils.RunnerId;
import io.flamingock.commons.utils.TimeService;
import io.flamingock.community.internal.lock.LocalLockService;
import io.flamingock.community.internal.lock.LockEntry;
import io.flamingock.core.engine.lock.LockAcquisition;
import io.flamingock.core.engine.lock.LockKey;
import io.flamingock.core.engine.lock.LockServiceException;
import io.flamingock.core.engine.lock.LockStatus;
import io.flamingock.oss.driver.common.mongodb.CollectionInitializator;
import io.flamingock.oss.driver.common.mongodb.CollectionWrapper;
import io.flamingock.oss.driver.common.mongodb.DocumentWrapper;
import io.flamingock.oss.driver.common.mongodb.MongoDBLockMapper;
import io.flamingock.oss.driver.mongodb.sync.v4.internal.mongodb.MongoSync4CollectionWrapper;
import io.flamingock.oss.driver.mongodb.sync.v4.internal.mongodb.MongoSync4DocumentWrapper;
import io.flamingock.oss.driver.mongodb.sync.v4.internal.mongodb.ReadWriteConfiguration;
import java.util.Date;
import org.bson.Document;
import org.bson.conversions.Bson;

public class MongoSync4LockService
implements LocalLockService {
    private final MongoDBLockMapper<MongoSync4DocumentWrapper> mapper = new MongoDBLockMapper(() -> new MongoSync4DocumentWrapper(new Document()));
    private final MongoCollection<Document> collection;
    private final TimeService timeService;

    protected MongoSync4LockService(MongoDatabase mongoDatabase, String lockCollectionName, ReadWriteConfiguration readWriteConfiguration, TimeService timeService) {
        this.collection = mongoDatabase.getCollection(lockCollectionName).withReadConcern(readWriteConfiguration.getReadConcern()).withReadPreference(readWriteConfiguration.getReadPreference()).withWriteConcern(readWriteConfiguration.getWriteConcern());
        this.timeService = timeService;
    }

    public void initialize(boolean indexCreation) {
        CollectionInitializator initializer = new CollectionInitializator((CollectionWrapper)new MongoSync4CollectionWrapper(this.collection), () -> new MongoSync4DocumentWrapper(new Document()), new String[]{"key"});
        if (indexCreation) {
            initializer.initialize();
        } else {
            initializer.justValidateCollection();
        }
    }

    public LockAcquisition upsert(LockKey key, RunnerId owner, long leaseMillis) {
        LockEntry newLock = new LockEntry(key.toString(), LockStatus.LOCK_HELD, owner.toString(), this.timeService.currentDatePlusMillis(leaseMillis));
        this.insertUpdate(newLock, false);
        return new LockAcquisition(owner, leaseMillis);
    }

    public LockAcquisition extendLock(LockKey key, RunnerId owner, long leaseMillis) throws LockServiceException {
        LockEntry newLock = new LockEntry(key.toString(), LockStatus.LOCK_HELD, owner.toString(), this.timeService.currentDatePlusMillis(leaseMillis));
        this.insertUpdate(newLock, true);
        return new LockAcquisition(owner, leaseMillis);
    }

    public LockAcquisition getLock(LockKey lockKey) {
        Document result = (Document)this.collection.find((Bson)new Document().append("key", (Object)lockKey.toString())).first();
        if (result != null) {
            return this.mapper.fromDocument((DocumentWrapper)new MongoSync4DocumentWrapper(result));
        }
        return null;
    }

    public void releaseLock(LockKey lockKey, RunnerId owner) {
        this.collection.deleteMany(Filters.and((Bson[])new Bson[]{Filters.eq((String)"key", (Object)lockKey.toString()), Filters.eq((String)"owner", (Object)owner.toString())}));
    }

    protected void insertUpdate(LockEntry newLock, boolean onlyIfSameOwner) {
        boolean lockHeld;
        String debErrorDetail = "not db error";
        Bson acquireLockQuery = this.getAcquireLockQuery(newLock.getKey(), newLock.getOwner(), onlyIfSameOwner);
        Document lockDocument = ((MongoSync4DocumentWrapper)this.mapper.toDocument(newLock)).getDocument();
        Document newLockDocumentSet = new Document().append("$set", (Object)lockDocument);
        try {
            UpdateResult result = this.collection.updateMany(acquireLockQuery, (Bson)newLockDocumentSet, new UpdateOptions().upsert(!onlyIfSameOwner));
            lockHeld = result.getModifiedCount() <= 0L && result.getUpsertedId() == null;
        }
        catch (MongoWriteException ex) {
            boolean bl = lockHeld = ex.getError().getCategory() == ErrorCategory.DUPLICATE_KEY;
            if (!lockHeld) {
                throw ex;
            }
            debErrorDetail = ex.getError().toString();
        }
        catch (DuplicateKeyException ex) {
            lockHeld = true;
            debErrorDetail = ex.getMessage();
        }
        if (lockHeld) {
            throw new LockServiceException(acquireLockQuery.toString(), newLockDocumentSet.toString(), debErrorDetail);
        }
    }

    protected Bson getAcquireLockQuery(String lockKey, String owner, boolean onlyIfSameOwner) {
        Bson expirationCond = Filters.lt((String)"expiresAt", (Object)new Date());
        Bson ownerCond = Filters.eq((String)"owner", (Object)owner);
        Bson keyCond = Filters.eq((String)"key", (Object)lockKey);
        Bson statusCond = Filters.eq((String)"status", (Object)LockStatus.LOCK_HELD.name());
        return onlyIfSameOwner ? Filters.and((Bson[])new Bson[]{keyCond, statusCond, ownerCond}) : Filters.and((Bson[])new Bson[]{keyCond, Filters.or((Bson[])new Bson[]{expirationCond, ownerCond})});
    }
}

