/*
 * Decompiled with CFR 0.152.
 */
package io.flamingock.oss.driver.mongodb.sync.v4.internal;

import com.mongodb.TransactionOptions;
import com.mongodb.client.ClientSession;
import io.flamingock.community.internal.TransactionManager;
import io.flamingock.core.runtime.dependency.DependencyInjectable;
import io.flamingock.core.task.descriptor.TaskDescriptor;
import io.flamingock.core.task.navigation.step.FailedStep;
import io.flamingock.core.transaction.TransactionWrapper;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MongoSync4TransactionWrapper
implements TransactionWrapper {
    private static final Logger logger = LoggerFactory.getLogger(MongoSync4TransactionWrapper.class);
    private final TransactionManager<ClientSession> sessionManager;

    MongoSync4TransactionWrapper(TransactionManager<ClientSession> sessionManager) {
        this.sessionManager = sessionManager;
    }

    /*
     * Loose catch block
     */
    public <T> T wrapInTransaction(TaskDescriptor taskDescriptor, DependencyInjectable dependencyInjectable, Supplier<T> operation) {
        String sessionId = taskDescriptor.getId();
        try {
            T t;
            try (ClientSession clientSession = (ClientSession)this.sessionManager.startSession(sessionId);){
                clientSession.startTransaction(TransactionOptions.builder().build());
                dependencyInjectable.addDependency((Object)clientSession);
                T result = operation.get();
                if (result instanceof FailedStep) {
                    clientSession.abortTransaction();
                } else {
                    clientSession.commitTransaction();
                }
                t = result;
            }
            return t;
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            this.sessionManager.closeSession(sessionId);
        }
    }
}

