/*
 * Decompiled with CFR 0.152.
 */
package io.flamingock.oss.driver.mongodb.sync.v4.internal.mongock;

import com.mongodb.client.MongoCollection;
import io.flamingock.core.api.LocalSystemModule;
import io.flamingock.core.engine.audit.AuditWriter;
import io.flamingock.core.runtime.dependency.Dependency;
import io.flamingock.oss.driver.mongodb.sync.v4.internal.mongock.InternalMongockImporterConfiguration;
import io.flamingock.oss.driver.mongodb.sync.v4.internal.mongock.MongockLocalLegacyImporterChangeUnit;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.bson.Document;

public class MongockImporterModule
implements LocalSystemModule {
    public static final List<Class<?>> TASK_CLASSES = Collections.singletonList(MongockLocalLegacyImporterChangeUnit.class);
    private List<Dependency> dependencies;
    private final MongoCollection<Document> sourceCollection;
    private final AuditWriter auditWriter;

    public MongockImporterModule(MongoCollection<Document> sourceCollection, AuditWriter auditWriter) {
        this.sourceCollection = sourceCollection;
        this.auditWriter = auditWriter;
    }

    public void initialise() {
        InternalMongockImporterConfiguration configuration = new InternalMongockImporterConfiguration(this.sourceCollection, this.auditWriter);
        this.dependencies = Collections.singletonList(new Dependency(InternalMongockImporterConfiguration.class, (Object)configuration));
    }

    public String getName() {
        return "mongodb-local-legacy-importer";
    }

    public Collection<Class<?>> getTaskClasses() {
        return TASK_CLASSES;
    }

    public int getOrder() {
        return 0;
    }

    public List<Dependency> getDependencies() {
        return this.dependencies;
    }

    public boolean isBeforeUserStages() {
        return true;
    }
}

