/*
 * Decompiled with CFR 0.152.
 */
package io.flinkspector.datastream;

import io.flinkspector.core.Order;
import io.flinkspector.core.collection.ExpectedRecords;
import io.flinkspector.core.input.Input;
import io.flinkspector.core.input.InputBuilder;
import io.flinkspector.core.quantify.HamcrestVerifier;
import io.flinkspector.core.runtime.OutputVerifier;
import io.flinkspector.core.trigger.VerifyFinishedTrigger;
import io.flinkspector.datastream.DataStreamTestEnvironment;
import io.flinkspector.datastream.functions.TestSink;
import io.flinkspector.datastream.input.EventTimeInput;
import io.flinkspector.datastream.input.EventTimeInputBuilder;
import io.flinkspector.datastream.input.EventTimeSourceBuilder;
import io.flinkspector.datastream.input.SourceBuilder;
import io.flinkspector.datastream.input.time.After;
import io.flinkspector.datastream.input.time.Before;
import io.flinkspector.datastream.input.time.InWindow;
import io.flinkspector.datastream.input.time.Moment;
import java.util.Collection;
import java.util.concurrent.TimeUnit;
import org.apache.flink.streaming.api.TimeCharacteristic;
import org.apache.flink.streaming.api.datastream.DataStream;
import org.apache.flink.streaming.api.datastream.DataStreamSource;
import org.hamcrest.Matcher;

public class DataStreamTestBase {
    public static final Order strict = Order.STRICT;
    public static final Order notStrict = Order.NONSTRICT;
    public static final TimeUnit seconds = TimeUnit.SECONDS;
    public static final TimeUnit minutes = TimeUnit.MINUTES;
    public static final TimeUnit hours = TimeUnit.HOURS;
    public static final String ignore = null;
    public DataStreamTestEnvironment testEnv;

    public static InWindow intoWindow(long time, TimeUnit unit) {
        return InWindow.to(time, unit);
    }

    public static After after(long span, TimeUnit unit) {
        return After.period(span, unit);
    }

    public static Before before(long span, TimeUnit unit) {
        return Before.period(span, unit);
    }

    public static <T> EventTimeInputBuilder<T> startWith(T record) {
        return EventTimeInputBuilder.startWith(record);
    }

    public static <T> InputBuilder<T> emit(T elem) {
        return InputBuilder.startWith(elem);
    }

    public static <T> ExpectedRecords<T> expectOutput(T record) {
        return ExpectedRecords.create(record);
    }

    public static int times(int n) {
        return n;
    }

    @org.junit.Before
    public void initialize() throws Exception {
        this.testEnv = DataStreamTestEnvironment.createTestEnvironment(1);
        this.testEnv.setStreamTimeCharacteristic(TimeCharacteristic.EventTime);
    }

    public Integer getParrallelism() {
        return this.testEnv.getParallelism();
    }

    public void setParrallelism(Integer parallelism) {
        this.testEnv.setParallelism(parallelism);
    }

    public <OUT> DataStreamSource<OUT> createTestStream(EventTimeInput<OUT> input) {
        return this.testEnv.fromInput(input);
    }

    public <OUT> SourceBuilder<OUT> createTestStreamWith(OUT record) {
        return SourceBuilder.createBuilder(record, this.testEnv);
    }

    public <OUT> EventTimeSourceBuilder<OUT> createTimedTestStreamWith(OUT record) {
        return EventTimeSourceBuilder.createBuilder(record, this.testEnv);
    }

    public <OUT> EventTimeSourceBuilder<OUT> createTimedTestStreamWith(OUT record, Long timestamp) {
        return EventTimeSourceBuilder.createBuilder(record, timestamp, this.testEnv);
    }

    public <OUT> EventTimeSourceBuilder<OUT> createTimedTestStreamWith(OUT record, Moment moment) {
        return EventTimeSourceBuilder.createBuilder(record, moment, this.testEnv);
    }

    public <OUT> DataStreamSource<OUT> createTestStream(Collection<OUT> input) {
        return this.testEnv.fromInput(input);
    }

    public <OUT> DataStreamSource<OUT> createTestStream(Input<OUT> input) {
        return this.testEnv.fromInput(input);
    }

    public <IN> TestSink<IN> createTestSink(Matcher<Iterable<IN>> matcher) {
        HamcrestVerifier verifier = new HamcrestVerifier(matcher);
        return this.createTestSink((OutputVerifier<IN>)verifier);
    }

    public <IN> TestSink<IN> createTestSink(OutputVerifier<IN> verifier, VerifyFinishedTrigger trigger) {
        return this.testEnv.createTestSink(verifier, trigger);
    }

    public <IN> TestSink<IN> createTestSink(OutputVerifier<IN> verifier) {
        return this.testEnv.createTestSink(verifier);
    }

    public <IN> TestSink<IN> createTestSink(Matcher<Iterable<IN>> matcher, VerifyFinishedTrigger trigger) {
        HamcrestVerifier verifier = new HamcrestVerifier(matcher);
        return this.createTestSink((OutputVerifier<IN>)verifier, trigger);
    }

    public <T> void assertStream(DataStream<T> stream, Matcher<Iterable<T>> matcher) {
        stream.addSink(this.createTestSink(matcher));
    }

    public <T> void assertStream(DataStream<T> stream, Matcher<Iterable<T>> matcher, VerifyFinishedTrigger trigger) {
        stream.addSink(this.createTestSink(matcher, trigger));
    }

    public void setParallelism(int parallelism) {
        this.testEnv.setParallelism(parallelism);
    }

    @org.junit.After
    public void executeTest() throws Throwable {
        this.testEnv.executeTest();
    }

    public void setTimeout(long interval) {
        this.testEnv.setTimeoutInterval(interval);
    }
}

