/*
 * Decompiled with CFR 0.152.
 */
package io.flinkspector.datastream.functions;

import com.lmax.disruptor.RingBuffer;
import io.flinkspector.core.runtime.OutputEvent;
import io.flinkspector.core.runtime.OutputPublisher;
import io.flinkspector.core.util.SerializeUtil;
import java.io.IOException;
import java.net.UnknownHostException;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.java.typeutils.TypeExtractor;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.streaming.api.functions.sink.RichSinkFunction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestSink<IN>
extends RichSinkFunction<IN> {
    private static RingBuffer<OutputEvent> buffer;
    private final int instance;
    private Logger LOG = LoggerFactory.getLogger(RichSinkFunction.class);
    private OutputPublisher handler;
    private TypeSerializer<IN> serializer;

    public TestSink(int instance, RingBuffer<OutputEvent> buffer) {
        this.instance = instance;
        TestSink.buffer = buffer;
    }

    public void open(Configuration configuration) throws UnknownHostException {
        String jobManagerAddress = configuration.getString("jobmanager.rpc.address", "localhost");
        this.handler = new OutputPublisher(this.instance, buffer);
    }

    public void invoke(IN next) {
        byte[] bytes;
        int numberOfSubTasks = this.getRuntimeContext().getNumberOfParallelSubtasks();
        int indexofThisSubTask = this.getRuntimeContext().getIndexOfThisSubtask();
        if (this.serializer == null) {
            TypeInformation typeInfo = TypeExtractor.getForObject(next);
            this.serializer = typeInfo.createSerializer(this.getRuntimeContext().getExecutionConfig());
            try {
                this.handler.sendOpen(indexofThisSubTask, numberOfSubTasks, SerializeUtil.serialize(this.serializer));
            }
            catch (IOException e) {
                this.LOG.error("Could not serialize TypeSerializer", (Throwable)e);
                return;
            }
        }
        try {
            bytes = SerializeUtil.serialize(next, this.serializer);
        }
        catch (IOException e) {
            this.LOG.error("Could not serialize input", (Throwable)e);
            return;
        }
        this.handler.sendRecord(bytes);
    }

    public void close() {
        this.handler.sendClose(this.getRuntimeContext().getIndexOfThisSubtask());
    }
}

