/*
 * Decompiled with CFR 0.152.
 */
package io.flinkspector.datastream.input;

import io.flinkspector.datastream.DataStreamTestEnvironment;
import io.flinkspector.datastream.input.EventTimeInputBuilder;
import io.flinkspector.datastream.input.time.Moment;
import io.flinkspector.datastream.input.time.TimeSpan;
import org.apache.flink.streaming.api.datastream.DataStreamSource;
import org.apache.flink.streaming.runtime.streamrecord.StreamRecord;

public class EventTimeSourceBuilder<T> {
    private final EventTimeInputBuilder<T> builder;
    private final DataStreamTestEnvironment env;

    public EventTimeSourceBuilder(DataStreamTestEnvironment env, T record) {
        this.env = env;
        this.builder = EventTimeInputBuilder.startWith(record);
    }

    public EventTimeSourceBuilder(DataStreamTestEnvironment env, T record, Long timestamp) {
        this.env = env;
        this.builder = EventTimeInputBuilder.startWith(record, timestamp);
    }

    public EventTimeSourceBuilder(DataStreamTestEnvironment env, T record, Moment moment) {
        this.env = env;
        this.builder = EventTimeInputBuilder.startWith(record, moment);
    }

    public static <T> EventTimeSourceBuilder<T> createBuilder(T record, DataStreamTestEnvironment env) {
        return new EventTimeSourceBuilder<T>(env, record);
    }

    public static <T> EventTimeSourceBuilder<T> createBuilder(T record, Long timestamp, DataStreamTestEnvironment env) {
        return new EventTimeSourceBuilder<T>(env, record, timestamp);
    }

    public static <T> EventTimeSourceBuilder<T> createBuilder(T record, Moment moment, DataStreamTestEnvironment env) {
        return new EventTimeSourceBuilder<T>(env, record, moment);
    }

    public DataStreamSource<T> close() {
        return this.env.fromInput(this.builder);
    }

    public DataStreamSource<T> closeAndFlush() {
        this.builder.flushOpenWindowsOnTermination();
        return this.env.fromInput(this.builder);
    }

    public EventTimeSourceBuilder<T> emit(T elem, long timeStamp) {
        this.builder.emit(new StreamRecord(elem, timeStamp));
        return this;
    }

    public EventTimeSourceBuilder<T> emit(T elem, Moment timeSpan) {
        this.builder.emit(elem, timeSpan);
        return this;
    }

    public EventTimeSourceBuilder<T> emit(T elem) {
        this.builder.emit(elem);
        return this;
    }

    public EventTimeSourceBuilder<T> emit(StreamRecord<T> streamRecord) {
        this.builder.emit(streamRecord);
        return this;
    }

    public EventTimeSourceBuilder<T> emit(T elem, Moment timeInterval, int times) {
        this.builder.emit(elem, timeInterval, times);
        return this;
    }

    public EventTimeSourceBuilder<T> repeatAll(TimeSpan timeSpan, int times) {
        this.builder.repeatAll(timeSpan, times);
        return this;
    }
}

