/*
 * Decompiled with CFR 0.152.
 */
package io.flinkspector.datastream.input;

import io.flinkspector.core.input.InputBuilder;
import io.flinkspector.datastream.DataStreamTestEnvironment;
import java.util.Collection;
import org.apache.flink.streaming.api.datastream.DataStreamSource;

public class SourceBuilder<T> {
    private final InputBuilder<T> builder = new InputBuilder();
    private final DataStreamTestEnvironment env;

    public SourceBuilder(DataStreamTestEnvironment env) {
        this.env = env;
    }

    public static <T> SourceBuilder<T> createBuilder(T record, DataStreamTestEnvironment env) {
        SourceBuilder<T> sourceBuilder = new SourceBuilder<T>(env);
        return sourceBuilder.emit(record);
    }

    public DataStreamSource<T> close() {
        return this.env.fromInput(this.builder);
    }

    public SourceBuilder<T> emit(T record) {
        this.builder.emit(record);
        return this;
    }

    public SourceBuilder<T> repeatAll(int times) {
        this.builder.repeatAll(times);
        return this;
    }

    public SourceBuilder<T> emit(T record, int times) {
        this.builder.emit(record, times);
        return this;
    }

    public SourceBuilder<T> emitAll(Collection<T> records) {
        this.builder.emitAll(records);
        return this;
    }
}

