/*
 * Decompiled with CFR 0.152.
 */
package io.floodplain.sink.sheet;

import com.google.api.client.auth.oauth2.Credential;
import com.google.api.client.googleapis.auth.oauth2.GoogleCredential;
import com.google.api.client.googleapis.javanet.GoogleNetHttpTransport;
import com.google.api.client.http.HttpRequestInitializer;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.http.javanet.NetHttpTransport;
import com.google.api.client.json.JsonFactory;
import com.google.api.client.json.jackson2.JacksonFactory;
import com.google.api.services.sheets.v4.Sheets;
import com.google.api.services.sheets.v4.model.BatchClearValuesRequest;
import com.google.api.services.sheets.v4.model.BatchClearValuesResponse;
import com.google.api.services.sheets.v4.model.BatchUpdateValuesRequest;
import com.google.api.services.sheets.v4.model.BatchUpdateValuesResponse;
import com.google.api.services.sheets.v4.model.UpdateValuesResponse;
import com.google.api.services.sheets.v4.model.ValueRange;
import io.floodplain.sink.sheet.UpdateTuple;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.GeneralSecurityException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SheetSink {
    private static GoogleCredential credential;
    private static final Logger logger;
    private final Sheets sheetsService = SheetSink.createSheetsService();

    private static Sheets createSheetsService() throws IOException, GeneralSecurityException {
        NetHttpTransport httpTransport = GoogleNetHttpTransport.newTrustedTransport();
        JacksonFactory jsonFactory = JacksonFactory.getDefaultInstance();
        Credential credential = SheetSink.getCredential();
        return new Sheets.Builder((HttpTransport)httpTransport, (JsonFactory)jsonFactory, (HttpRequestInitializer)credential).setApplicationName("Google-Sheets/0.1").build();
    }

    public static Credential getCredential() throws IOException {
        String path = Optional.ofNullable(System.getenv("GOOGLE_SHEETS_CREDENTIAL_PATH")).orElse("/kafka/credentials.json");
        if (credential == null) {
            try (FileInputStream is = new FileInputStream(path);){
                credential = GoogleCredential.fromStream((InputStream)is).createScoped(Collections.singleton("https://www.googleapis.com/auth/spreadsheets"));
            }
        }
        return credential;
    }

    public List<List<Object>> extractRow(Map<String, Object> message, String[] columns) {
        ArrayList<Object> list2 = new ArrayList<Object>();
        for (String column : columns) {
            list2.add(message.get(column));
        }
        return Collections.singletonList(list2);
    }

    public List<String> clear(String spreadsheetId, List<String> ranges) throws IOException {
        BatchClearValuesRequest requestBody = new BatchClearValuesRequest();
        requestBody.setRanges(ranges);
        Sheets.Spreadsheets.Values.BatchClear request = this.sheetsService.spreadsheets().values().batchClear(spreadsheetId, requestBody);
        BatchClearValuesResponse response = (BatchClearValuesResponse)request.execute();
        return response.getClearedRanges();
    }

    public List<List<Object>> getRange(String spreadsheetId, String range) throws IOException {
        return ((ValueRange)this.sheetsService.spreadsheets().values().get(spreadsheetId, range).execute()).getValues();
    }

    public void updateRange(String spreadsheetId, String range, List<List<Object>> values) throws IOException {
        String valueInputOption = "RAW";
        ValueRange requestBody = new ValueRange();
        requestBody.setValues(values);
        logger.info("Adding {} rows to sheet", (Object)values.size());
        Sheets.Spreadsheets.Values.Update request = this.sheetsService.spreadsheets().values().update(spreadsheetId, range, requestBody);
        request.setValueInputOption(valueInputOption);
        request.set("key", (Object)"");
        UpdateValuesResponse response = (UpdateValuesResponse)request.execute();
        logger.info("Response: {}", (Object)response);
    }

    public void updateRangeWithBatch(String spreadsheetId, List<UpdateTuple> tuples) throws IOException {
        String valueInputOption = "RAW";
        ArrayList data = new ArrayList();
        tuples.forEach(tuple -> data.add(new ValueRange().setRange(tuple.range).setValues(tuple.values)));
        BatchUpdateValuesRequest body = new BatchUpdateValuesRequest().setValueInputOption(valueInputOption).setData(data);
        Sheets.Spreadsheets.Values.BatchUpdate request = this.sheetsService.spreadsheets().values().batchUpdate(spreadsheetId, body);
        request.set("key", (Object)"");
        BatchUpdateValuesResponse response = (BatchUpdateValuesResponse)request.execute();
        logger.info("Response: {}", (Object)response);
    }

    static {
        logger = LoggerFactory.getLogger(SheetSink.class);
    }
}

