/*
 * Decompiled with CFR 0.152.
 */
package io.floodplain.test;

import com.github.dockerjava.api.command.CreateContainerCmd;
import com.github.dockerjava.api.command.InspectContainerResponse;
import io.floodplain.test.InstantiatedContainerKt;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.testcontainers.containers.GenericContainer;
import org.testcontainers.containers.wait.strategy.Wait;
import org.testcontainers.containers.wait.strategy.WaitStrategy;
import org.testcontainers.images.builder.Transferable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\n\u0012\u0006\u0012\u0004\u0018\u00010\u00000\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0012\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\nH\u0014R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u000b"}, d2={"Lio/floodplain/test/RedpandaContainer;", "Lorg/testcontainers/containers/GenericContainer;", "image", "", "(Ljava/lang/String;)V", "getImage", "()Ljava/lang/String;", "containerIsStarting", "", "containerInfo", "Lcom/github/dockerjava/api/command/InspectContainerResponse;", "floodplain-test"})
public final class RedpandaContainer
extends GenericContainer<RedpandaContainer> {
    @NotNull
    private final String image;

    public RedpandaContainer(@NotNull String image) {
        Intrinsics.checkNotNullParameter((Object)image, (String)"image");
        super(image);
        this.image = image;
        Object[] objectArray = new Integer[]{9092};
        this.withExposedPorts((Integer[])objectArray);
        this.withStartupTimeout(Duration.ofMinutes(5L));
        this.withCreateContainerCmdModifier(RedpandaContainer::_init_$lambda$0);
        objectArray = new String[]{"-c", "while [ ! -f /testcontainers_start.sh ]; do sleep 0.1; done; /testcontainers_start.sh"};
        this.withCommand((String[])objectArray);
        this.waitingFor((WaitStrategy)Wait.forLogMessage((String)".*Started Kafka API server.*", (int)1));
    }

    @NotNull
    public final String getImage() {
        return this.image;
    }

    protected void containerIsStarting(@Nullable InspectContainerResponse containerInfo) {
        super.containerIsStarting(containerInfo);
        String command = "#!/bin/bash\n";
        command = command + "/usr/bin/rpk redpanda start --check=false --node-id 0 ";
        command = command + "--kafka-addr PLAINTEXT://0.0.0.0:29092,OUTSIDE://0.0.0.0:9092 ";
        command = command + "--set redpanda.enable_idempotence=true ";
        command = command + "--set redpanda.enable_transactions=true ";
        command = command + "--advertise-kafka-addr PLAINTEXT://broker:29092,OUTSIDE://" + this.getHost() + ':' + this.getMappedPort(9092) + '\n';
        InstantiatedContainerKt.access$getLogger$p().info("command: " + command);
        InstantiatedContainerKt.access$getLogger$p().info("mapped port: " + this.getHost() + ':' + this.getMappedPort(9092));
        String string = command;
        Charset charset = StandardCharsets.UTF_8;
        Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"UTF_8");
        byte[] byArray = string.getBytes(charset);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"this as java.lang.String).getBytes(charset)");
        this.copyFileToContainer(Transferable.of((byte[])byArray, (int)511), "/testcontainers_start.sh");
        InstantiatedContainerKt.access$getLogger$p().info("Copied to location: /testcontainers_start.sh");
    }

    private static final void _init_$lambda$0(CreateContainerCmd cmd) {
        String[] stringArray = new String[]{"sh"};
        cmd.withEntrypoint(stringArray);
    }
}

