/*
 * Decompiled with CFR 0.152.
 */
package io.floodplain.replication.api;

import io.floodplain.immutable.api.ImmutableMessage;
import io.floodplain.replication.api.ReplicationMessageParser;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public interface ReplicationMessage {
    public static final String KEYSEPARATOR = "<$>";
    public static final String PRETTY_JSON = "PRETTY_JSON";

    public String transactionId();

    public Optional<String> source();

    public long timestamp();

    public Operation operation();

    public List<String> primaryKeys();

    public Set<String> columnNames();

    public Optional<Object> value(String var1);

    public ImmutableMessage.ValueType columnType(String var1);

    public boolean equals(Object var1);

    public String queueKey();

    public boolean isErrorMessage();

    public Map<String, Object> valueMap(boolean var1, Set<String> var2);

    public Map<String, Object> valueMap(boolean var1, Set<String> var2, List<String> var3);

    public Map<String, Object> flatValueMap(boolean var1, Set<String> var2, String var3);

    public boolean equalsToMessage(ReplicationMessage var1);

    public boolean equalsByKey(ReplicationMessage var1);

    public byte[] toBytes(ReplicationMessageParser var1);

    public Optional<List<ImmutableMessage>> subMessages(String var1);

    public Optional<ImmutableMessage> subMessage(String var1);

    public ReplicationMessage withImmutableMessage(ImmutableMessage var1);

    public ReplicationMessage withSubMessages(String var1, List<ImmutableMessage> var2);

    public ReplicationMessage withSubMessage(String var1, ImmutableMessage var2);

    public ReplicationMessage withAddedSubMessage(String var1, ImmutableMessage var2);

    public ReplicationMessage withoutSubMessageInList(String var1, Predicate<ImmutableMessage> var2);

    public ReplicationMessage withoutSubMessages(String var1);

    public ReplicationMessage withoutSubMessage(String var1);

    public Set<String> subMessageListNames();

    public ReplicationMessage without(String var1);

    public ReplicationMessage without(List<String> var1);

    public ReplicationMessage with(String var1, Object var2, ImmutableMessage.ValueType var3);

    public ReplicationMessage rename(String var1, String var2);

    public ReplicationMessage withPrimaryKeys(List<String> var1);

    public ReplicationMessage now();

    public ReplicationMessage atTime(long var1);

    public String toFlatString(ReplicationMessageParser var1);

    public static boolean usePrettyPrint() {
        return System.getenv(PRETTY_JSON) != null || System.getProperty(PRETTY_JSON) != null;
    }

    public ReplicationMessage withOperation(Operation var1);

    public Map<String, Object> values();

    public ImmutableMessage message();

    public Optional<ImmutableMessage> paramMessage();

    public ReplicationMessage withParamMessage(ImmutableMessage var1);

    public ReplicationMessage withoutParamMessage();

    default public String combinedKey() {
        return this.primaryKeys().stream().map(k -> this.value((String)k).get().toString()).collect(Collectors.joining(KEYSEPARATOR));
    }

    public static enum Operation {
        UPDATE,
        DELETE,
        NONE,
        COMMIT,
        MERGE,
        INITIAL;

    }
}

