/*
 * Decompiled with CFR 0.152.
 */
package io.floodplain.replication.factory;

import io.floodplain.immutable.api.ImmutableMessage;
import io.floodplain.replication.api.ReplicationMessage;
import io.floodplain.replication.api.ReplicationMessageParser;
import io.floodplain.replication.impl.ReplicationImmutableMessageImpl;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class ReplicationFactory {
    private static ReplicationMessageParser instance;
    private static final Runnable noopCommit;

    public static ReplicationMessageParser getInstance() {
        return instance;
    }

    public static void setInstance(ReplicationMessageParser parser) {
        instance = parser;
    }

    public static ReplicationMessage createReplicationMessage(Optional<String> source, Optional<Integer> partition, Optional<Long> offset, String transactionId, long timestamp, ReplicationMessage.Operation operation, List<String> primaryKeys, Map<String, ImmutableMessage.ValueType> types, Map<String, Object> values, Map<String, ImmutableMessage> subMessageMap, Map<String, List<ImmutableMessage>> subMessageListMap, Optional<Runnable> commitAction, Optional<ImmutableMessage> paramMessage) {
        return new ReplicationImmutableMessageImpl(source, partition, offset, transactionId, operation, timestamp, values, types, subMessageMap, subMessageListMap, primaryKeys, commitAction, paramMessage);
    }

    public static ReplicationMessage createReplicationMessage(Optional<String> source, Optional<Integer> partition, Optional<Long> offset, String transactionId, long timestamp, ReplicationMessage.Operation operation, List<String> primaryKeys, ImmutableMessage message, Optional<Runnable> commitAction, Optional<ImmutableMessage> paramMessage) {
        return new ReplicationImmutableMessageImpl(source, partition, offset, transactionId, operation, timestamp, message, primaryKeys, commitAction, paramMessage);
    }

    public static ReplicationMessage fromMap(String key, Map<String, Object> values, Map<String, ImmutableMessage.ValueType> types) {
        List<String> keys = key == null ? Collections.emptyList() : Collections.singletonList(key);
        return ReplicationFactory.createReplicationMessage(Optional.empty(), Optional.empty(), Optional.empty(), null, System.currentTimeMillis(), ReplicationMessage.Operation.NONE, keys, types, values, Collections.emptyMap(), Collections.emptyMap(), Optional.of(noopCommit), Optional.empty());
    }

    public static ReplicationMessage create(Map<String, Object> values, Map<String, ImmutableMessage.ValueType> types) {
        return ReplicationFactory.createReplicationMessage(Optional.empty(), Optional.empty(), Optional.empty(), null, System.currentTimeMillis(), ReplicationMessage.Operation.NONE, Collections.emptyList(), types, values, Collections.emptyMap(), Collections.emptyMap(), Optional.of(noopCommit), Optional.empty());
    }

    public static ReplicationMessage create(Map<String, Object> dataMap) {
        return new ReplicationImmutableMessageImpl(dataMap);
    }

    public static ReplicationMessage empty() {
        return ReplicationFactory.createReplicationMessage(Optional.empty(), Optional.empty(), Optional.empty(), null, System.currentTimeMillis(), ReplicationMessage.Operation.NONE, Collections.emptyList(), Collections.emptyMap(), Collections.emptyMap(), Collections.emptyMap(), Collections.emptyMap(), Optional.of(noopCommit), Optional.empty());
    }

    public static ReplicationMessage createErrorReplicationMessage(Throwable t) {
        return new ReplicationImmutableMessageImpl(t);
    }

    public static ReplicationMessage standardMessage(ImmutableMessage msg) {
        return new ReplicationImmutableMessageImpl(Optional.empty(), Optional.empty(), Optional.empty(), null, ReplicationMessage.Operation.NONE, -1L, msg, Collections.emptyList(), Optional.empty(), Optional.empty());
    }

    static {
        noopCommit = () -> {};
    }
}

