/*
 * Decompiled with CFR 0.152.
 */
package io.floodplain.replication.impl;

import io.floodplain.immutable.api.ImmutableMessage;
import io.floodplain.immutable.factory.ImmutableFactory;
import io.floodplain.replication.api.ReplicationMessage;
import io.floodplain.replication.api.ReplicationMessageParser;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReplicationImmutableMessageImpl
implements ReplicationMessage {
    private static final Logger logger = LoggerFactory.getLogger(ReplicationImmutableMessageImpl.class);
    private final Optional<String> source;
    private final String transactionId;
    private final long timestamp;
    private final ReplicationMessage.Operation operation;
    private final List<String> primaryKeys;
    private Optional<Runnable> commitAction;
    private final Optional<Integer> partition;
    private final Optional<Long> offset;
    private final ImmutableMessage immutableMessage;
    private final Optional<ImmutableMessage> paramMessage;

    public ReplicationImmutableMessageImpl(Optional<String> source, Optional<Integer> partition, Optional<Long> offset, String transactionId, ReplicationMessage.Operation operation, long timestamp, Map<String, Object> values, Map<String, ImmutableMessage.ValueType> types, Map<String, ImmutableMessage> submessage, Map<String, List<ImmutableMessage>> submessages, List<String> primaryKeys, Optional<Runnable> commitAction, Optional<ImmutableMessage> paramMessage) {
        this.immutableMessage = ImmutableFactory.create(values, types, submessage, submessages);
        this.transactionId = transactionId;
        this.timestamp = timestamp;
        this.operation = operation;
        this.primaryKeys = Collections.unmodifiableList(primaryKeys);
        this.commitAction = commitAction;
        this.source = source;
        this.partition = partition;
        this.offset = offset;
        this.paramMessage = paramMessage;
    }

    public ReplicationImmutableMessageImpl(Optional<String> source, Optional<Integer> partition, Optional<Long> offset, String transactionId, ReplicationMessage.Operation operation, long timestamp, ImmutableMessage parentMessage, List<String> primaryKeys, Optional<Runnable> commitAction, Optional<ImmutableMessage> paramMessage) {
        this.immutableMessage = parentMessage;
        this.transactionId = transactionId;
        this.timestamp = timestamp;
        this.operation = operation;
        this.primaryKeys = Collections.unmodifiableList(primaryKeys);
        this.commitAction = commitAction;
        this.source = source;
        this.offset = offset;
        this.partition = partition;
        this.paramMessage = paramMessage;
    }

    public ImmutableMessage message() {
        return this.immutableMessage;
    }

    public Set<String> subMessageListNames() {
        return this.message().subMessageListNames();
    }

    public String queueKey() {
        if (this.primaryKeys.size() == 0) {
            return "NO_KEY_PRESENT";
        }
        return String.join((CharSequence)"<$>", this.primaryKeys.stream().map(col -> this.value((String)col)).filter(e -> e.isPresent()).map(e -> e.get().toString()).collect(Collectors.toList()));
    }

    public byte[] toBytes(ReplicationMessageParser c) {
        return c.serialize((ReplicationMessage)this);
    }

    public boolean equals(Object other) {
        if (!(other instanceof ReplicationMessage)) {
            return false;
        }
        return this.equalsByKey((ReplicationMessage)other);
    }

    public boolean equalsByKey(ReplicationMessage other) {
        String key = this.queueKey();
        if (key == null) {
            return super.equals(other);
        }
        return key.equals(other.queueKey());
    }

    public int hashCode() {
        String key = this.queueKey();
        if (key == null) {
            return super.hashCode();
        }
        return key.hashCode();
    }

    public ReplicationImmutableMessageImpl(Throwable t) {
        logger.error("Creating failure replication message", t);
        t.printStackTrace(System.err);
        t.printStackTrace(System.out);
        this.transactionId = null;
        this.timestamp = -1L;
        this.operation = ReplicationMessage.Operation.UPDATE;
        this.primaryKeys = Collections.emptyList();
        this.immutableMessage = ImmutableFactory.create(Collections.emptyMap(), Collections.emptyMap(), Collections.emptyMap(), Collections.emptyMap());
        this.source = Optional.empty();
        this.partition = Optional.empty();
        this.offset = Optional.empty();
        this.paramMessage = Optional.empty();
    }

    public ReplicationImmutableMessageImpl(Map<String, Object> initial) {
        this.transactionId = (String)initial.get("TransactionId");
        this.timestamp = (Long)initial.get("Timestamp");
        this.operation = ReplicationMessage.Operation.valueOf((String)((String)initial.get("Operation")));
        this.primaryKeys = Collections.unmodifiableList((List)initial.get("PrimaryKeys"));
        Map<String, Object> initialValues = Collections.unmodifiableMap((Map)initial.get("Columns"));
        this.immutableMessage = ImmutableFactory.create(initialValues, this.resolveTypesFromValues(initialValues), Collections.emptyMap(), Collections.emptyMap());
        this.source = Optional.empty();
        this.partition = Optional.empty();
        this.offset = Optional.empty();
        this.paramMessage = Optional.empty();
    }

    private Map<String, ImmutableMessage.ValueType> resolveTypesFromValues(Map<String, Object> values) {
        HashMap<String, ImmutableMessage.ValueType> t = new HashMap<String, ImmutableMessage.ValueType>();
        for (Map.Entry<String, Object> e : values.entrySet()) {
            Object val = e.getValue();
            if (val == null) continue;
            if (val instanceof Long) {
                t.put(e.getKey(), ImmutableMessage.ValueType.LONG);
                continue;
            }
            if (val instanceof Double) {
                t.put(e.getKey(), ImmutableMessage.ValueType.DOUBLE);
                continue;
            }
            if (val instanceof Integer) {
                t.put(e.getKey(), ImmutableMessage.ValueType.INTEGER);
                continue;
            }
            if (val instanceof Float) {
                t.put(e.getKey(), ImmutableMessage.ValueType.FLOAT);
                continue;
            }
            if (val instanceof Date) {
                t.put(e.getKey(), ImmutableMessage.ValueType.DATE);
                continue;
            }
            if (val instanceof Boolean) {
                t.put(e.getKey(), ImmutableMessage.ValueType.BOOLEAN);
                continue;
            }
            if (val instanceof String) {
                t.put(e.getKey(), ImmutableMessage.ValueType.STRING);
                continue;
            }
            logger.warn("Unknown type::: {}", val.getClass());
            t.put(e.getKey(), ImmutableMessage.ValueType.STRING);
        }
        return t;
    }

    public Map<String, Object> valueMap(boolean ignoreNull, Set<String> ignore) {
        return this.valueMap(ignoreNull, ignore, Collections.emptyList());
    }

    public Map<String, Object> valueMap(boolean ignoreNull, Set<String> ignore, List<String> currentPath) {
        return this.message().valueMap(ignoreNull, ignore, currentPath);
    }

    public boolean isErrorMessage() {
        return this.transactionId == null;
    }

    public String transactionId() {
        return this.transactionId;
    }

    public long timestamp() {
        return this.timestamp;
    }

    public ReplicationMessage.Operation operation() {
        return this.operation;
    }

    public List<String> primaryKeys() {
        return this.primaryKeys;
    }

    public Set<String> columnNames() {
        return this.message().columnNames();
    }

    public Optional<Object> value(String columnName) {
        return this.message().value(columnName);
    }

    public ImmutableMessage.ValueType columnType(String name) {
        return this.message().columnType(name);
    }

    public String toString() {
        return "Operation: " + this.operation.toString() + " Ts: " + this.timestamp + "Transactionid: " + this.transactionId + " pk: " + this.primaryKeys + "Value:\n" + this.message().toString();
    }

    public Optional<List<ImmutableMessage>> subMessages(String field) {
        return this.message().subMessages(field);
    }

    public Optional<ImmutableMessage> subMessage(String field) {
        return this.message().subMessage(field);
    }

    public ReplicationMessage withImmutableMessage(ImmutableMessage msg) {
        return new ReplicationImmutableMessageImpl(this.source, this.partition, this.offset, this.transactionId, this.operation, this.timestamp, msg, this.primaryKeys, this.commitAction, this.paramMessage);
    }

    public ReplicationMessage withSubMessages(String field, List<ImmutableMessage> message) {
        return this.withImmutableMessage(this.message().withSubMessages(field, message));
    }

    public ReplicationMessage withSubMessage(String field, ImmutableMessage message) {
        return this.withImmutableMessage(this.message().withSubMessage(field, message));
    }

    public ReplicationMessage without(String columnName) {
        LinkedList<String> prim = new LinkedList<String>(this.primaryKeys());
        prim.remove(columnName);
        return this.withImmutableMessage(this.message().without(columnName)).withPrimaryKeys(Collections.unmodifiableList(prim));
    }

    public ReplicationMessage without(List<String> columns) {
        LinkedList<String> prim = new LinkedList<String>(this.primaryKeys());
        prim.removeAll(columns);
        return this.withImmutableMessage(this.message().without(columns)).withPrimaryKeys(Collections.unmodifiableList(prim));
    }

    public ReplicationMessage rename(String columnName, String newName) {
        int keyIndex = this.primaryKeys.indexOf(columnName);
        List<String> primary = this.primaryKeys;
        if (keyIndex != -1) {
            primary = new ArrayList<String>(this.primaryKeys);
            primary.set(keyIndex, newName);
        }
        return this.withImmutableMessage(this.message().rename(columnName, newName)).withPrimaryKeys(primary);
    }

    public ReplicationMessage with(String key, Object value, ImmutableMessage.ValueType type) {
        return this.withImmutableMessage(this.message().with(key, value, type));
    }

    public ReplicationMessage withPrimaryKeys(List<String> primary) {
        return new ReplicationImmutableMessageImpl(this.source, this.partition, this.offset, this.transactionId, this.operation, this.timestamp, this.message(), primary, this.commitAction, this.paramMessage);
    }

    public String toFlatString(ReplicationMessageParser parser) {
        return parser.describe((ReplicationMessage)this);
    }

    public ReplicationMessage withoutSubMessages(String field) {
        return this.withImmutableMessage(this.message().withoutSubMessages(field));
    }

    public ReplicationMessage withoutSubMessage(String field) {
        return this.withImmutableMessage(this.message().withoutSubMessage(field));
    }

    public ReplicationMessage withAddedSubMessage(String field, ImmutableMessage message) {
        return this.withImmutableMessage(this.message().withAddedSubMessage(field, message));
    }

    public ReplicationMessage withoutSubMessageInList(String field, Predicate<ImmutableMessage> selector) {
        return this.withImmutableMessage(this.message().withoutSubMessageInList(field, selector));
    }

    public ReplicationMessage withOperation(ReplicationMessage.Operation operation) {
        return new ReplicationImmutableMessageImpl(this.source, this.partition, this.offset, this.transactionId, operation, this.timestamp, this.message(), this.primaryKeys, this.commitAction, this.paramMessage);
    }

    public Map<String, Object> flatValueMap(boolean ignoreNull, Set<String> ignore, String prefix) {
        Map param = this.paramMessage.map(prm -> prm.flatValueMap(ignoreNull, ignore, prefix + "@param")).orElse(Collections.emptyMap());
        Map flatValueMap = this.message().flatValueMap(ignoreNull, ignore, prefix);
        HashMap combined = new HashMap(flatValueMap);
        combined.putAll(param);
        return Collections.unmodifiableMap(combined);
    }

    public boolean equalsToMessage(ReplicationMessage c) {
        Map other = c.flatValueMap(false, Collections.emptySet(), "");
        Map<String, Object> myMap = this.flatValueMap(false, Collections.emptySet(), "");
        return myMap.equals(other);
    }

    public ReplicationMessage now() {
        return this.atTime(new Date().getTime());
    }

    public ReplicationMessage atTime(long timestamp) {
        return new ReplicationImmutableMessageImpl(this.source, this.partition, this.offset, this.transactionId, this.operation, timestamp, this.message(), this.primaryKeys, this.commitAction, this.paramMessage);
    }

    public Map<String, Object> values() {
        return this.message().values();
    }

    public Optional<String> source() {
        return this.source;
    }

    public Optional<ImmutableMessage> paramMessage() {
        return this.paramMessage;
    }

    public ReplicationMessage withParamMessage(ImmutableMessage msg) {
        return new ReplicationImmutableMessageImpl(this.source, this.partition, this.offset, this.transactionId, this.operation, this.timestamp, this.message(), this.primaryKeys, this.commitAction, Optional.of(msg));
    }

    public ReplicationMessage withoutParamMessage() {
        return new ReplicationImmutableMessageImpl(this.source, this.partition, this.offset, this.transactionId, this.operation, this.timestamp, this.message(), this.primaryKeys, this.commitAction, Optional.empty());
    }
}

