/*
 * Decompiled with CFR 0.152.
 */
package io.floodplain.replication.impl.json;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectWriter;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import io.floodplain.replication.api.ReplicationMessage;
import io.floodplain.replication.api.ReplicationMessageParser;
import io.floodplain.replication.factory.ReplicationFactory;
import io.floodplain.replication.impl.json.ReplicationJSON;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Named;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named(value="json")
@ApplicationScoped
public class JSONReplicationMessageParserImpl
implements ReplicationMessageParser {
    private static final Logger logger = LoggerFactory.getLogger(JSONReplicationMessageParserImpl.class);
    private final boolean includeNullValues = true;

    public ReplicationMessage parseJson(Optional<String> source, ObjectNode on) {
        return ReplicationJSON.parseJSON(source, on);
    }

    public ReplicationMessage parseBytes(Optional<String> source, byte[] data) {
        if (data == null) {
            return null;
        }
        try {
            return ReplicationJSON.parseReplicationMessage(data, source);
        }
        catch (JsonProcessingException e) {
            return ReplicationFactory.createErrorReplicationMessage((Throwable)e);
        }
        catch (Throwable e) {
            return ReplicationFactory.createErrorReplicationMessage((Throwable)e);
        }
    }

    public ReplicationMessage parseStream(InputStream data) {
        return this.parseStream(Optional.empty(), data);
    }

    public ReplicationMessage parseStream(Optional<String> source, InputStream data) {
        try {
            JsonNode node = ReplicationJSON.objectMapper.readTree(data);
            return ReplicationJSON.parseJSON(source, (ObjectNode)node);
        }
        catch (JsonProcessingException e) {
            return ReplicationFactory.createErrorReplicationMessage((Throwable)e);
        }
        catch (IOException e) {
            return ReplicationFactory.createErrorReplicationMessage((Throwable)e);
        }
    }

    public List<ReplicationMessage> parseMessageList(Optional<String> source, byte[] data) {
        try {
            JsonNode node = ReplicationJSON.objectMapper.readTree(data);
            return this.parseJSONNode(source, node);
        }
        catch (JsonProcessingException e) {
            LinkedList<ReplicationMessage> result = new LinkedList<ReplicationMessage>();
            result.add(ReplicationFactory.createErrorReplicationMessage((Throwable)e));
            return Collections.unmodifiableList(result);
        }
        catch (Throwable e) {
            LinkedList<ReplicationMessage> result = new LinkedList<ReplicationMessage>();
            result.add(ReplicationFactory.createErrorReplicationMessage((Throwable)e));
            return Collections.unmodifiableList(result);
        }
    }

    private List<ReplicationMessage> parseJSONNode(Optional<String> source, JsonNode node) {
        LinkedList<ReplicationMessage> result = new LinkedList<ReplicationMessage>();
        if (!(node instanceof ArrayNode)) {
            logger.warn("Node is not an array, so can't parse to list, will create list of one!");
            ObjectNode on = (ObjectNode)node;
            ReplicationMessage single = ReplicationJSON.parseJSON(source, on);
            result.add(single);
            return Collections.unmodifiableList(result);
        }
        ArrayNode elements = (ArrayNode)node;
        for (JsonNode jsonNode : elements) {
            ObjectNode on = (ObjectNode)jsonNode;
            result.add(ReplicationJSON.parseJSON(source, on));
        }
        return Collections.unmodifiableList(result);
    }

    public byte[] serializeMessageList(List<ReplicationMessage> data) {
        ArrayNode list = ReplicationJSON.objectMapper.createArrayNode();
        data.stream().map(msg -> ReplicationJSON.toJSON(msg, true)).forEach(arg_0 -> ((ArrayNode)list).add(arg_0));
        try {
            ObjectWriter w = ReplicationMessage.usePrettyPrint() ? ReplicationJSON.objectMapper.writerWithDefaultPrettyPrinter() : ReplicationJSON.objectMapper.writer();
            return w.writeValueAsBytes((Object)list);
        }
        catch (JsonProcessingException e) {
            logger.error("Error: ", (Throwable)e);
            return null;
        }
    }

    public byte[] serialize(ReplicationMessage msg) {
        return ReplicationJSON.jsonSerializer(msg, true);
    }

    public String describe(ReplicationMessage msg) {
        return ReplicationJSON.jsonDescriber(msg);
    }

    public List<ReplicationMessage> parseMessageList(Optional<String> source, InputStream data) {
        try {
            JsonNode node = ReplicationJSON.objectMapper.readTree(data);
            return this.parseJSONNode(source, node);
        }
        catch (JsonProcessingException e) {
            LinkedList<ReplicationMessage> result = new LinkedList<ReplicationMessage>();
            result.add(ReplicationFactory.createErrorReplicationMessage((Throwable)e));
            return Collections.unmodifiableList(result);
        }
        catch (Throwable e) {
            LinkedList<ReplicationMessage> result = new LinkedList<ReplicationMessage>();
            result.add(ReplicationFactory.createErrorReplicationMessage((Throwable)e));
            return Collections.unmodifiableList(result);
        }
    }

    public List<ReplicationMessage> parseMessageList(byte[] data) {
        return this.parseMessageList(Optional.empty(), data);
    }
}

