/*
 * Decompiled with CFR 0.152.
 */
package io.floodplain.replication.impl.json;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectWriter;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.NullNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import io.floodplain.immutable.api.ImmutableMessage;
import io.floodplain.immutable.api.ImmutableTypeParser;
import io.floodplain.immutable.factory.ImmutableFactory;
import io.floodplain.replication.api.ReplicationMessage;
import io.floodplain.replication.factory.ReplicationFactory;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.nio.charset.StandardCharsets;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReplicationJSON {
    private static final Logger logger = LoggerFactory.getLogger(ReplicationJSON.class);
    public static final ObjectMapper objectMapper = new ObjectMapper();

    public static ReplicationMessage parseReplicationMessage(byte[] data, Optional<String> source) throws IOException {
        return ReplicationJSON.parseJSON(source, (ObjectNode)ReplicationJSON.parseJSON(data));
    }

    public static byte[] jsonSerializer(ReplicationMessage msg, boolean includeNullValues) {
        return ReplicationJSON.jsonSerializer(msg, includeNullValues, false);
    }

    public static byte[] jsonSerializer(ReplicationMessage msg, boolean includeNullValues, boolean dumpKey) {
        try {
            ObjectWriter w = ReplicationMessage.usePrettyPrint() ? objectMapper.writerWithDefaultPrettyPrinter() : objectMapper.writer();
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            if (dumpKey) {
                baos.write(msg.combinedKey().getBytes(StandardCharsets.UTF_8));
                baos.write(9);
            }
            w.writeValue((OutputStream)baos, (Object)ReplicationJSON.toJSON(msg, includeNullValues));
            baos.write(10);
            return baos.toByteArray();
        }
        catch (JsonProcessingException e) {
            logger.error("JSON parsing failing with key: {} value: {} submessagenames: {}", new Object[]{msg.queueKey(), msg.values(), msg.message().subMessageMap().keySet()});
            logger.error("Error serializing, got json error:", (Throwable)e);
            if (e.getCause() != null) {
                logger.error("Error serializing cause:", e.getCause());
                e.printStackTrace();
            }
            try {
                logger.error("JSON failed to write: {}", (Object)ReplicationJSON.toJSON(msg, includeNullValues).toString());
            }
            catch (Throwable t) {
                logger.error("Logging issue: ", t);
            }
            return "{}".getBytes(StandardCharsets.UTF_8);
        }
        catch (IOException e) {
            throw new RuntimeException("Weird json problem", e);
        }
    }

    public static String jsonDescriber(ReplicationMessage msg) {
        return msg.flatValueMap(true, Collections.emptySet(), "").toString();
    }

    private static JsonNode parseJSON(byte[] data) throws IOException {
        try {
            return objectMapper.readTree(data);
        }
        catch (Throwable t) {
            logger.error("Exception on parsing json! {}", (Object)new String(data, StandardCharsets.UTF_8), (Object)t);
            throw t;
        }
    }

    static void resolveValue(ObjectNode m, String key, ImmutableMessage.ValueType type, Object value, boolean includeNullValues) {
        if (value == null) {
            if (includeNullValues) {
                m.putNull(key);
            }
            return;
        }
        if (value instanceof Optional) {
            Optional o = (Optional)value;
            if (o.isEmpty()) {
                if (includeNullValues) {
                    m.putNull(key);
                }
                return;
            }
            throw new RuntimeException("Unexpected optional for " + key + " type: " + type);
        }
        if (type == null) {
            throw new IllegalArgumentException("Null type for key: " + key);
        }
        switch (type) {
            case STRING: 
            case BINARY_DIGEST: {
                m.put("Value", (String)value);
                return;
            }
            case DECIMAL: {
                m.put("Value", ((BigDecimal)value).toPlainString());
                return;
            }
            case INTEGER: {
                m.put("Value", (Integer)value);
                return;
            }
            case LONG: {
                m.put("Value", (Long)value);
                return;
            }
            case DOUBLE: {
                m.put("Value", (Double)value);
                return;
            }
            case FLOAT: {
                if (value instanceof Float) {
                    m.put("Value", (Float)value);
                } else {
                    m.put("Value", (Double)value);
                }
                return;
            }
            case BOOLEAN: {
                m.put("Value", (Boolean)value);
                return;
            }
            case DATE: {
                if (value instanceof String) {
                    m.put("Value", (String)value);
                } else {
                    String t = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SS").format((Date)value);
                    m.put("Value", t);
                }
                return;
            }
            case CLOCKTIME: {
                if (value instanceof String) {
                    m.put("Value", (String)value);
                } else {
                    String c = new SimpleDateFormat("HH:mm:ss").format((Date)value);
                    m.put("Value", c);
                }
                return;
            }
            case STRINGLIST: {
                ArrayNode stringArrayNode = m.putArray("Value");
                if (value instanceof String[]) {
                    ArrayNode conf = (ArrayNode)objectMapper.valueToTree(value);
                    stringArrayNode.addAll(conf);
                    break;
                }
                if (!(value instanceof List)) break;
                ArrayNode conf = (ArrayNode)objectMapper.valueToTree(value);
                stringArrayNode.addAll(conf);
                break;
            }
            case BINARY: {
                m.put("Value", Base64.getEncoder().encodeToString((byte[])value));
                break;
            }
            case ENUM: {
                m.put("Value", (String)value);
                break;
            }
            default: {
                logger.warn("Unknown type: {} while serializing replication message to JSON. ", (Object)type);
            }
        }
    }

    public static Object resolveValue(ImmutableMessage.ValueType type, JsonNode jsonNode) {
        if (jsonNode == null) {
            return null;
        }
        if (jsonNode instanceof NullNode) {
            return null;
        }
        switch (type) {
            case STRING: 
            case BINARY_DIGEST: 
            case ENUM: {
                return jsonNode.asText();
            }
            case DECIMAL: {
                return new BigDecimal(jsonNode.asText());
            }
            case INTEGER: {
                return jsonNode.asInt();
            }
            case LONG: {
                return jsonNode.asLong();
            }
            case DOUBLE: 
            case FLOAT: {
                return jsonNode.asDouble();
            }
            case BOOLEAN: {
                return jsonNode.asBoolean();
            }
            case BINARY: {
                return jsonNode.isNull() ? new byte[]{} : Base64.getDecoder().decode(jsonNode.asText());
            }
            case STRINGLIST: {
                ArrayNode stringNode = (ArrayNode)jsonNode;
                ArrayList<String> stringResult = new ArrayList<String>();
                for (JsonNode objNode : stringNode) {
                    if (objNode.isTextual()) {
                        stringResult.add(objNode.asText());
                        continue;
                    }
                    logger.warn("Unsupported array element type: {} in {}. Ignoring!", (Object)objNode, (Object)jsonNode);
                }
                return stringResult;
            }
            case DATE: {
                try {
                    return new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SS").parse(jsonNode.asText());
                }
                catch (ParseException e) {
                    logger.warn("Cannot parse date {} = returning null", (Object)jsonNode.asText());
                    return null;
                }
            }
            case CLOCKTIME: {
                try {
                    return new SimpleDateFormat("HH:mm:ss").parse(jsonNode.asText());
                }
                catch (ParseException e) {
                    logger.warn("Cannot parse clocktime {} = returning null", (Object)jsonNode.asText());
                    return null;
                }
            }
        }
        logger.warn("Unsupported type {}", (Object)type);
        return null;
    }

    public static ObjectNode toJSON(ReplicationMessage instance, boolean includeNullValues) {
        ObjectNode node = objectMapper.createObjectNode();
        try {
            if (instance.transactionId() != null) {
                node.put("TransactionId", instance.transactionId());
            }
            node.put("Timestamp", instance.timestamp());
            node.put("Operation", instance.operation().toString());
            ArrayNode keys = objectMapper.createArrayNode();
            for (String key : instance.primaryKeys()) {
                keys.add(key);
            }
            node.set("PrimaryKeys", (JsonNode)keys);
            ImmutableMessage immutable = instance.message();
            ReplicationJSON.appendImmutable(node, immutable, includeNullValues);
            Optional paramMessage = instance.paramMessage();
            if (paramMessage.isPresent()) {
                ObjectNode paramNode = objectMapper.createObjectNode();
                node.set("ParamMessage", (JsonNode)paramNode);
                ReplicationJSON.appendImmutable(paramNode, (ImmutableMessage)paramMessage.get(), includeNullValues);
            }
        }
        catch (Throwable e) {
            logger.error("Error serializing replicationmessage " + instance.queueKey() + " columns: " + instance.values(), e);
        }
        return node;
    }

    public static ObjectNode replicationToJSON(ReplicationMessage msg) {
        ObjectNode node = objectMapper.createObjectNode();
        node.set("payload", (JsonNode)ReplicationJSON.immutableToJSON(msg.message()));
        ObjectNode schema = objectMapper.createObjectNode();
        node.set("schema", (JsonNode)schema);
        return node;
    }

    public static byte[] replicationToConnectJSON(ReplicationMessage msg) {
        ObjectNode node = ReplicationJSON.replicationToJSON(msg);
        try {
            return objectMapper.writerWithDefaultPrettyPrinter().writeValueAsBytes((Object)node);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException("Error writing json", e);
        }
    }

    public static byte[] immutableTotalToJSON(ImmutableMessage msg) {
        try {
            ObjectNode node = objectMapper.createObjectNode();
            ReplicationJSON.appendImmutable(node, msg, false);
            return objectMapper.writerWithDefaultPrettyPrinter().writeValueAsBytes((Object)node);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException("Error writing json", e);
        }
    }

    private static ObjectNode immutableToJSON(ImmutableMessage msg) {
        ObjectNode node = objectMapper.createObjectNode();
        Map values = msg.toTypedDataMap();
        for (Map.Entry e : values.entrySet()) {
            Object o = ((ImmutableMessage.TypedData)e.getValue()).value;
            String key2 = (String)e.getKey();
            if (o == null) continue;
            switch (((ImmutableMessage.TypedData)e.getValue()).type) {
                case BOOLEAN: {
                    node.put(key2, (Boolean)o);
                    break;
                }
                case DATE: {
                    node.put(key2, ((Date)o).toGMTString());
                    break;
                }
                case DECIMAL: {
                    node.put(key2, ((BigDecimal)o).toPlainString());
                    break;
                }
                case DOUBLE: 
                case FLOAT: {
                    node.put(key2, (Double)o);
                    break;
                }
                case INTEGER: {
                    node.put(key2, (Integer)o);
                    break;
                }
                case STRINGLIST: {
                    String[] rs = (String[])o;
                    ArrayNode alist = objectMapper.createArrayNode();
                    for (String element : rs) {
                        alist.add(element);
                    }
                    node.set(key2, (JsonNode)alist);
                    break;
                }
                case LONG: {
                    node.put(key2, (Long)o);
                    break;
                }
                case STRING: {
                    node.put(key2, (String)o);
                    break;
                }
                case ENUM: {
                    node.put(key2, o.toString());
                    break;
                }
                case IMMUTABLE: {
                    break;
                }
                case BINARY: {
                    break;
                }
                case BINARY_DIGEST: 
                case STOPWATCHTIME: {
                    throw new RuntimeException("Whoops, illegal type: " + ((ImmutableMessage.TypedData)e.getValue()).type);
                }
                case UNKNOWN: {
                    break;
                }
            }
        }
        msg.subMessageMap().forEach((key, value) -> node.set(key, (JsonNode)ReplicationJSON.immutableToJSON(value)));
        msg.subMessageListMap().forEach((key, value) -> {
            ArrayNode al = objectMapper.createArrayNode();
            value.stream().map(ReplicationJSON::immutableToJSON).forEach(arg_0 -> ((ArrayNode)al).add(arg_0));
            node.set(key, (JsonNode)al);
        });
        return node;
    }

    private static void appendImmutable(ObjectNode node, ImmutableMessage immutable, boolean includeNullValues) throws JsonProcessingException {
        ObjectNode columns = objectMapper.createObjectNode();
        node.set("Columns", (JsonNode)columns);
        Map types = immutable.types();
        for (Map.Entry e : immutable.values().entrySet()) {
            String key = (String)e.getKey();
            ImmutableMessage.ValueType type = (ImmutableMessage.ValueType)types.get(key);
            Object value = e.getValue();
            if (type == ImmutableMessage.ValueType.UNKNOWN && value != null) {
                String msg = objectMapper.writerWithDefaultPrettyPrinter().writeValueAsString((Object)node);
                logger.error("Unknown type detected while appending key: {} and node: {}", (Object)key, (Object)msg);
            }
            if (value == null && type == ImmutableMessage.ValueType.UNKNOWN) continue;
            ObjectNode m = objectMapper.createObjectNode();
            m.put("Type", ImmutableTypeParser.typeName((ImmutableMessage.ValueType)type));
            ReplicationJSON.resolveValue(m, key, type, value, includeNullValues);
            columns.set((String)e.getKey(), (JsonNode)m);
        }
        ObjectNode subMessage = null;
        if (immutable.subMessageMap() != null || immutable.subMessageListMap() != null) {
            subMessage = objectMapper.createObjectNode();
            node.set("SubMessage", (JsonNode)subMessage);
        }
        if (subMessage != null) {
            if (immutable.subMessageMap() != null) {
                for (Map.Entry entry : immutable.subMessageMap().entrySet()) {
                    subMessage.set((String)entry.getKey(), (JsonNode)ReplicationJSON.toJSONImmutable((ImmutableMessage)entry.getValue(), includeNullValues));
                }
            }
            if (immutable.subMessageListMap() != null) {
                for (Map.Entry entry : immutable.subMessageListMap().entrySet()) {
                    ArrayNode arraynode = objectMapper.createArrayNode();
                    subMessage.set((String)entry.getKey(), (JsonNode)arraynode);
                    List list = (List)entry.getValue();
                    for (ImmutableMessage msg : list) {
                        arraynode.add((JsonNode)ReplicationJSON.toJSONImmutable(msg, includeNullValues));
                    }
                }
            }
        }
    }

    private static ObjectNode toJSONImmutable(ImmutableMessage immutable, boolean includeNullValues) {
        ObjectNode node = objectMapper.createObjectNode();
        try {
            node.put("TransactionId", "");
            node.put("Timestamp", -1L);
            node.put("Operation", ReplicationMessage.Operation.NONE.name());
            ArrayNode keys = objectMapper.createArrayNode();
            node.set("PrimaryKeys", (JsonNode)keys);
            ReplicationJSON.appendImmutable(node, immutable, includeNullValues);
        }
        catch (Throwable e) {
            logger.error("Error serializing replicationmessage.", e);
            e.printStackTrace();
        }
        return node;
    }

    public static ReplicationMessage parseJSON(Optional<String> source, ObjectNode node) {
        List l;
        String transactionId = node.get("TransactionId") != null ? node.get("TransactionId").asText() : null;
        long timestamp = node.get("Timestamp") != null ? node.get("Timestamp").asLong() : -1L;
        ReplicationMessage.Operation operation = node.get("Operation") != null ? ReplicationMessage.Operation.valueOf((String)node.get("Operation").asText().toUpperCase()) : ReplicationMessage.Operation.NONE;
        ArrayNode keys = (ArrayNode)node.get("PrimaryKeys");
        if (keys != null) {
            l = new ArrayList();
            for (JsonNode key : keys) {
                l.add(key.asText());
            }
        } else {
            l = Collections.emptyList();
        }
        List primaryKeys = Collections.unmodifiableList(l);
        ImmutableMessage flatMessage = ReplicationJSON.parseImmutable(node);
        ObjectNode paramMsg = (ObjectNode)node.get("ParamMessage");
        return ReplicationFactory.createReplicationMessage(source, Optional.empty(), Optional.empty(), (String)transactionId, (long)timestamp, (ReplicationMessage.Operation)operation, primaryKeys, (ImmutableMessage)flatMessage, Optional.empty(), Optional.ofNullable(paramMsg).map(ReplicationJSON::parseImmutable));
    }

    public static ImmutableMessage parseImmutable(byte[] data) throws IOException {
        return ReplicationJSON.parseImmutable((ObjectNode)ReplicationJSON.parseJSON(data));
    }

    private static ImmutableMessage parseImmutable(ObjectNode node) {
        Map subMessageListMap;
        Map subMessageMap;
        ObjectNode val = (ObjectNode)node.get("Columns");
        HashMap<String, Object> localvalues = new HashMap<String, Object>();
        HashMap<String, ImmutableMessage.ValueType> localtypes = new HashMap<String, ImmutableMessage.ValueType>();
        if (val != null) {
            Iterator it = val.fields();
            while (it.hasNext()) {
                Map.Entry e = (Map.Entry)it.next();
                String name = (String)e.getKey();
                ObjectNode column = (ObjectNode)e.getValue();
                JsonNode typeObject = column.get("Type");
                if (typeObject == null) {
                    try {
                        logger.error("Null type found in replication message: " + objectMapper.writerWithDefaultPrettyPrinter().writeValueAsString((Object)node));
                    }
                    catch (JsonProcessingException e1) {
                        logger.error("Error: ", (Throwable)e1);
                    }
                    throw new IllegalArgumentException("Missing type in json!");
                }
                ImmutableMessage.ValueType type = ImmutableTypeParser.parseType((String)typeObject.asText());
                if (type == ImmutableMessage.ValueType.UNKNOWN) {
                    try {
                        String serialized = objectMapper.writerWithDefaultPrettyPrinter().writeValueAsString((Object)node);
                        logger.error("Unknown type detected while parsing JSON: {}", (Object)serialized);
                    }
                    catch (JsonProcessingException ex) {
                        ex.printStackTrace();
                    }
                }
                Object value = ReplicationJSON.resolveValue(type, column.get("Value"));
                localvalues.put(name, value);
                localtypes.put(name, type);
            }
        }
        Map types = Collections.unmodifiableMap(localtypes);
        Map values = Collections.unmodifiableMap(localvalues);
        ObjectNode subMessage = (ObjectNode)node.get("SubMessage");
        if (subMessage != null) {
            HashMap<String, ImmutableMessage> inProgressSubMessageMap = null;
            HashMap inProgressSubMessageListMap = null;
            Iterator it = subMessage.fields();
            while (it.hasNext()) {
                ObjectNode sub;
                Map.Entry e = (Map.Entry)it.next();
                String name = (String)e.getKey();
                JsonNode json = (JsonNode)e.getValue();
                if (json instanceof ObjectNode) {
                    sub = (ObjectNode)json;
                    ImmutableMessage subMessageImpl = ReplicationJSON.parseImmutable(sub);
                    if (inProgressSubMessageMap == null) {
                        inProgressSubMessageMap = new HashMap<String, ImmutableMessage>();
                    }
                    inProgressSubMessageMap.put(name, subMessageImpl);
                    continue;
                }
                if (!(json instanceof ArrayNode)) continue;
                sub = (ArrayNode)json;
                LinkedList<ImmutableMessage> msgs = new LinkedList<ImmutableMessage>();
                for (JsonNode element : sub) {
                    ImmutableMessage subMessageImpl = ReplicationJSON.parseImmutable((ObjectNode)element);
                    msgs.add(subMessageImpl);
                }
                if (inProgressSubMessageListMap == null) {
                    inProgressSubMessageListMap = new HashMap();
                }
                inProgressSubMessageListMap.put(name, Collections.unmodifiableList(msgs));
            }
            subMessageMap = inProgressSubMessageMap == null ? Collections.emptyMap() : Collections.unmodifiableMap(inProgressSubMessageMap);
            subMessageListMap = inProgressSubMessageListMap == null ? Collections.emptyMap() : Collections.unmodifiableMap(inProgressSubMessageListMap);
        } else {
            subMessageMap = Collections.emptyMap();
            subMessageListMap = Collections.emptyMap();
        }
        return ImmutableFactory.create(values, types, subMessageMap, subMessageListMap);
    }
}

