/*
 * Decompiled with CFR 0.152.
 */
package io.floodplain.replication.impl.protobuf;

import com.fasterxml.jackson.core.JsonProcessingException;
import io.floodplain.replication.api.ReplicationMessage;
import io.floodplain.replication.api.ReplicationMessageParser;
import io.floodplain.replication.impl.json.JSONReplicationMessageParserImpl;
import io.floodplain.replication.impl.protobuf.impl.ProtobufReplicationMessageParser;
import java.io.IOException;
import java.io.InputStream;
import java.io.PushbackInputStream;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.inject.Default;
import javax.inject.Named;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named(value="protobuffallback")
@ApplicationScoped
@Default
public class FallbackReplicationMessageParser
implements ReplicationMessageParser {
    private final ReplicationMessageParser primary;
    private final ReplicationMessageParser secondary = new JSONReplicationMessageParserImpl();
    private JsonProcessingException p;
    private static final Logger logger = LoggerFactory.getLogger(FallbackReplicationMessageParser.class);

    public FallbackReplicationMessageParser() {
        this(true);
    }

    public FallbackReplicationMessageParser(boolean useProtobuf) {
        this.primary = useProtobuf ? new ProtobufReplicationMessageParser() : new JSONReplicationMessageParserImpl();
    }

    private ReplicationMessageParser determineType(byte[] data) {
        if (data == null) {
            return this.primary;
        }
        if ((short)data[0] != 8) {
            return this.secondary;
        }
        if ((short)data[1] != -21) {
            return this.secondary;
        }
        return this.primary;
    }

    private InputStream determineType(InputStream data, List<ReplicationMessageParser> result) {
        PushbackInputStream pis = new PushbackInputStream(data, 2);
        try {
            byte[] pre = new byte[2];
            int read = pis.read(pre);
            if (read < 2) {
                throw new IllegalArgumentException("Can't determine type of data: Insufficient data");
            }
            if ((short)pre[0] != 8) {
                result.add(this.secondary);
            }
            if ((short)pre[1] != -21) {
                result.add(this.secondary);
            }
            pis.unread(pre);
            result.add(this.primary);
        }
        catch (IOException e) {
            logger.error("Error: ", (Throwable)e);
            result.add(this.secondary);
        }
        return pis;
    }

    public ReplicationMessage parseBytes(Optional<String> source, byte[] data) {
        return this.determineType(data).parseBytes(source, data);
    }

    public List<ReplicationMessage> parseMessageList(byte[] data) {
        return this.determineType(data).parseMessageList(data);
    }

    public ReplicationMessage parseStream(InputStream data) {
        return this.parseStream(Optional.empty(), data);
    }

    public ReplicationMessage parseStream(Optional<String> source, InputStream data) {
        LinkedList<ReplicationMessageParser> res = new LinkedList<ReplicationMessageParser>();
        InputStream is = this.determineType(data, res);
        ReplicationMessageParser parser = (ReplicationMessageParser)res.stream().findFirst().get();
        return parser.parseStream(is);
    }

    public List<ReplicationMessage> parseMessageList(Optional<String> source, InputStream data) {
        LinkedList<ReplicationMessageParser> res = new LinkedList<ReplicationMessageParser>();
        InputStream is = this.determineType(data, res);
        ReplicationMessageParser parser = (ReplicationMessageParser)res.stream().findFirst().get();
        return parser.parseMessageList(source, is);
    }

    public byte[] serializeMessageList(List<ReplicationMessage> msg) {
        if (msg == null) {
            throw new NullPointerException("Describing null message list!");
        }
        return this.primary.serializeMessageList(msg);
    }

    public byte[] serialize(ReplicationMessage msg) {
        if (msg == null) {
            throw new NullPointerException("Serializing null message!");
        }
        return this.primary.serialize(msg);
    }

    public String describe(ReplicationMessage msg) {
        if (msg == null) {
            throw new NullPointerException("Describing null message!");
        }
        return this.primary.describe(msg);
    }

    public List<ReplicationMessage> parseMessageList(Optional<String> source, byte[] data) {
        throw new UnsupportedOperationException("Not implemented");
    }
}

