/*
 * Decompiled with CFR 0.152.
 */
package io.floodplain.replication.impl.protobuf.impl;

import com.google.protobuf.ByteString;
import com.google.protobuf.InvalidProtocolBufferException;
import io.floodplain.immutable.api.ImmutableMessage;
import io.floodplain.immutable.factory.ImmutableFactory;
import io.floodplain.protobuf.generated.Replication;
import io.floodplain.replication.api.ReplicationMessage;
import io.floodplain.replication.api.ReplicationMessageParser;
import io.floodplain.replication.factory.ReplicationFactory;
import java.io.IOException;
import java.io.InputStream;
import java.io.PushbackInputStream;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Named;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named(value="protobuf")
@ApplicationScoped
public class ProtobufReplicationMessageParser
implements ReplicationMessageParser {
    private static final Logger logger = LoggerFactory.getLogger(ProtobufReplicationMessageParser.class);
    public static final int MAGIC = 12779;
    public static final byte MAGIC_BYTE_1 = 8;
    public static final byte MAGIC_BYTE_2 = -21;
    public static final DateTimeFormatter dateFormatter = DateTimeFormatter.ofPattern("yyyy-MM-dd");
    public static final DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss.SSSSSS");
    public static final DateTimeFormatter clocktimeFormatter = DateTimeFormatter.ofPattern("HH:mm:ss");

    private static String serializeValue(ImmutableMessage.ValueType type, Object val) {
        if (val == null) {
            return null;
        }
        switch (type) {
            case STRING: {
                return (String)val;
            }
            case INTEGER: {
                return Integer.toString((Integer)val);
            }
            case LONG: {
                return Long.toString((Long)val);
            }
            case DOUBLE: {
                return Double.toString((Double)val);
            }
            case FLOAT: {
                if (val instanceof Float) {
                    return Float.toString(((Float)val).floatValue());
                }
                if (val instanceof Double) {
                    return Double.toString((Double)val);
                }
            }
            case BOOLEAN: {
                return Boolean.toString((Boolean)val);
            }
            case BINARY_DIGEST: {
                return (String)val;
            }
            case BINARY: {
                logger.info("Binary type: {}", val.getClass());
                return (String)val;
            }
            case DATE: {
                if (val instanceof String) {
                    return (String)val;
                }
                if (val instanceof LocalDateTime) {
                    return dateFormatter.format((LocalDateTime)val);
                }
                if (val instanceof LocalDate) {
                    return dateFormatter.format((LocalDate)val);
                }
                logger.info("Unexpected date type: {}", val);
            }
            case CLOCKTIME: {
                if (val instanceof String) {
                    return (String)val;
                }
                if (val instanceof LocalDateTime) {
                    return dateTimeFormatter.format((LocalDateTime)val);
                }
                if (val instanceof LocalDate) {
                    dateFormatter.format((LocalDate)val);
                }
                return clocktimeFormatter.format((LocalTime)val);
            }
            case ENUM: {
                return val.toString();
            }
            case TIMESTAMP: {
                if (val instanceof LocalDateTime) {
                    return dateTimeFormatter.format((LocalDateTime)val);
                }
                throw new UnsupportedOperationException("Unknown type: " + type);
            }
            case DECIMAL: {
                return ((BigDecimal)val).toPlainString();
            }
            case STRINGLIST: {
                List v = (List)val;
                return v.stream().collect(Collectors.joining(","));
            }
        }
        throw new UnsupportedOperationException("Unknown type: " + type);
    }

    private static Object protobufValue(Replication.ValueProtobuf val) {
        if (val.getIsNull()) {
            return null;
        }
        String value = val.getValue();
        switch (val.getType()) {
            case STRING: {
                return value;
            }
            case INTEGER: {
                return Integer.parseInt(value);
            }
            case LONG: {
                return Long.parseLong(value);
            }
            case DOUBLE: {
                return Double.parseDouble(value);
            }
            case FLOAT: {
                return Float.valueOf(Float.parseFloat(value));
            }
            case BOOLEAN: {
                return Boolean.parseBoolean(value);
            }
            case BINARY: {
                return val.getByteData() == null ? new byte[]{} : val.getByteData().toByteArray();
            }
            case BINARY_DIGEST: {
                return value;
            }
            case DATE: {
                try {
                    return LocalDate.parse(value, dateFormatter);
                }
                catch (DateTimeParseException e) {
                    logger.warn("Error parsing date: " + value + " with type: " + val.getType().name(), (Throwable)e);
                    return null;
                }
            }
            case CLOCKTIME: {
                try {
                    return LocalTime.parse(value, clocktimeFormatter);
                }
                catch (DateTimeParseException e) {
                    logger.warn("Error parsing clocktime: " + value + " with type: " + val.getType().name(), (Throwable)e);
                    return null;
                }
            }
            case TIMESTAMP: {
                try {
                    return LocalDateTime.parse(value, dateTimeFormatter);
                }
                catch (DateTimeParseException e) {
                    logger.warn("Error parsing timestamp: " + value + " with type: " + val.getType().name(), (Throwable)e);
                    return null;
                }
            }
            case DECIMAL: {
                return new BigDecimal(value);
            }
            case LIST: {
                return value;
            }
            case ENUM: {
                return value;
            }
            case STRINGLIST: {
                return Arrays.asList(value.split(","));
            }
        }
        logger.warn("Unknown type: {} for value: {}", (Object)val.getType(), (Object)val.getValue());
        return null;
    }

    private static Replication.ValueProtobuf.ValueType parseType(ImmutableMessage.ValueType type) {
        switch (type) {
            case STRING: {
                return Replication.ValueProtobuf.ValueType.STRING;
            }
            case INTEGER: {
                return Replication.ValueProtobuf.ValueType.INTEGER;
            }
            case LONG: {
                return Replication.ValueProtobuf.ValueType.LONG;
            }
            case DOUBLE: {
                return Replication.ValueProtobuf.ValueType.DOUBLE;
            }
            case FLOAT: {
                return Replication.ValueProtobuf.ValueType.FLOAT;
            }
            case BOOLEAN: {
                return Replication.ValueProtobuf.ValueType.BOOLEAN;
            }
            case BINARY_DIGEST: {
                return Replication.ValueProtobuf.ValueType.BINARY_DIGEST;
            }
            case DATE: {
                return Replication.ValueProtobuf.ValueType.DATE;
            }
            case TIMESTAMP: {
                return Replication.ValueProtobuf.ValueType.TIMESTAMP;
            }
            case STRINGLIST: {
                return Replication.ValueProtobuf.ValueType.STRINGLIST;
            }
            case BINARY: {
                return Replication.ValueProtobuf.ValueType.BINARY;
            }
            case CLOCKTIME: {
                return Replication.ValueProtobuf.ValueType.CLOCKTIME;
            }
            case ENUM: {
                return Replication.ValueProtobuf.ValueType.ENUM;
            }
            case DECIMAL: {
                return Replication.ValueProtobuf.ValueType.DECIMAL;
            }
            case STOPWATCHTIME: 
            case IMMUTABLE: 
            case UNKNOWN: 
            case IMMUTABLELIST: {
                return Replication.ValueProtobuf.ValueType.UNRECOGNIZED;
            }
        }
        return Replication.ValueProtobuf.ValueType.UNRECOGNIZED;
    }

    public static ImmutableMessage.ValueType convertType(Replication.ValueProtobuf.ValueType type) {
        switch (type) {
            case STRING: {
                return ImmutableMessage.ValueType.STRING;
            }
            case INTEGER: {
                return ImmutableMessage.ValueType.INTEGER;
            }
            case LONG: {
                return ImmutableMessage.ValueType.LONG;
            }
            case DOUBLE: {
                return ImmutableMessage.ValueType.DOUBLE;
            }
            case FLOAT: {
                return ImmutableMessage.ValueType.FLOAT;
            }
            case BOOLEAN: {
                return ImmutableMessage.ValueType.BOOLEAN;
            }
            case BINARY_DIGEST: {
                return ImmutableMessage.ValueType.BINARY_DIGEST;
            }
            case DATE: {
                return ImmutableMessage.ValueType.DATE;
            }
            case TIMESTAMP: {
                return ImmutableMessage.ValueType.TIMESTAMP;
            }
            case CLOCKTIME: {
                return ImmutableMessage.ValueType.CLOCKTIME;
            }
            case BINARY: {
                return ImmutableMessage.ValueType.BINARY;
            }
            case ENUM: {
                return ImmutableMessage.ValueType.ENUM;
            }
            case DECIMAL: {
                return ImmutableMessage.ValueType.DECIMAL;
            }
            case LIST: 
            case STRINGLIST: {
                return ImmutableMessage.ValueType.STRINGLIST;
            }
            case UNRECOGNIZED: {
                return ImmutableMessage.ValueType.UNKNOWN;
            }
        }
        return ImmutableMessage.ValueType.UNKNOWN;
    }

    public static ImmutableMessage parseImmutableMessage(Replication.ReplicationMessageProtobuf source) {
        return ProtobufReplicationMessageParser.parseImmutableMessage(source, true);
    }

    public static ImmutableMessage parseImmutableMessage(Replication.ReplicationMessageProtobuf source, boolean checkMagic) {
        HashMap<String, Object> values = new HashMap<String, Object>();
        HashMap<String, ImmutableMessage.ValueType> types = new HashMap<String, ImmutableMessage.ValueType>();
        if (checkMagic && 12779 != source.getMagic()) {
            throw new IllegalArgumentException("Bad magic: " + source.getMagic());
        }
        for (Map.Entry<String, Replication.ValueProtobuf> entry : source.getValuesMap().entrySet()) {
            types.put(entry.getKey(), ProtobufReplicationMessageParser.convertType(entry.getValue().getType()));
            values.put(entry.getKey(), ProtobufReplicationMessageParser.protobufValue(entry.getValue()));
        }
        HashMap<String, ImmutableMessage> submessage = new HashMap<String, ImmutableMessage>();
        for (Map.Entry<String, Replication.ReplicationMessageProtobuf> entry : source.getSubmessageMap().entrySet()) {
            submessage.put(entry.getKey(), ProtobufReplicationMessageParser.parseImmutableMessage(entry.getValue()));
        }
        HashMap hashMap = new HashMap();
        for (Map.Entry<String, Replication.ReplicationMessageListProtobuf> elt : source.getSubmessageListMap().entrySet()) {
            List rm = elt.getValue().getElementsList().stream().map(r -> ProtobufReplicationMessageParser.parseImmutableMessage(r)).collect(Collectors.toList());
            hashMap.put(elt.getKey(), rm);
        }
        return ImmutableFactory.create(values, types, submessage, hashMap);
    }

    public static ReplicationMessage parse(Optional<String> topicSrc, Replication.ReplicationMessageProtobuf source, Optional<Runnable> commitAction) {
        HashMap<String, Object> values = new HashMap<String, Object>();
        HashMap<String, ImmutableMessage.ValueType> types = new HashMap<String, ImmutableMessage.ValueType>();
        if (12779 != source.getMagic()) {
            throw new IllegalArgumentException("Bad magic");
        }
        for (Map.Entry<String, Replication.ValueProtobuf> entry : source.getValuesMap().entrySet()) {
            types.put(entry.getKey(), ProtobufReplicationMessageParser.convertType(entry.getValue().getType()));
            values.put(entry.getKey(), ProtobufReplicationMessageParser.protobufValue(entry.getValue()));
        }
        HashMap<String, ImmutableMessage> submessage = new HashMap<String, ImmutableMessage>();
        for (Map.Entry<String, Replication.ReplicationMessageProtobuf> entry : source.getSubmessageMap().entrySet()) {
            submessage.put(entry.getKey(), ProtobufReplicationMessageParser.parseImmutableMessage(entry.getValue()));
        }
        HashMap hashMap = new HashMap();
        for (Map.Entry<String, Replication.ReplicationMessageListProtobuf> entry : source.getSubmessageListMap().entrySet()) {
            List rm = entry.getValue().getElementsList().stream().map(r -> ProtobufReplicationMessageParser.parseImmutableMessage(r)).collect(Collectors.toList());
            hashMap.put(entry.getKey(), rm);
        }
        Optional<ImmutableMessage> optional = Optional.ofNullable(source.getParamMessage()).map(msg -> ProtobufReplicationMessageParser.parseImmutableMessage(msg, false));
        return ReplicationFactory.createReplicationMessage(topicSrc, Optional.empty(), Optional.empty(), (String)source.getTransactionId(), (long)source.getTimestamp(), (ReplicationMessage.Operation)ReplicationMessage.Operation.valueOf((String)source.getOperation().name()), source.getPrimarykeysList().stream().collect(Collectors.toList()), types, values, submessage, hashMap, commitAction, optional);
    }

    public byte[] serialize(ReplicationMessage m) {
        byte[] byteArray = ProtobufReplicationMessageParser.toProto(m).toByteArray();
        if ((short)byteArray[0] != 8) {
            throw new IllegalArgumentException("Bad magic byte: " + (short)byteArray[0]);
        }
        if ((short)byteArray[1] != -21) {
            throw new IllegalArgumentException("Bad magic byte" + (short)byteArray[1]);
        }
        return byteArray;
    }

    public String describe(ReplicationMessage m) {
        return ProtobufReplicationMessageParser.toProto(m).toString();
    }

    private static Replication.ReplicationMessageProtobuf toProto(ReplicationMessage msg) {
        return ProtobufReplicationMessageParser.toProto(msg.message(), msg.transactionId(), msg.operation(), msg.timestamp(), msg.primaryKeys(), msg.paramMessage());
    }

    private static Replication.ReplicationMessageProtobuf toProto(ImmutableMessage msg) {
        return ProtobufReplicationMessageParser.toProto(msg, null, ReplicationMessage.Operation.NONE, -1L, Collections.emptyList(), Optional.empty());
    }

    private static Replication.ReplicationMessageProtobuf toProto(ImmutableMessage msg, String transactionId, ReplicationMessage.Operation operation, long timestamp, List<String> primaryKeys, Optional<ImmutableMessage> paramMessage) {
        Map<String, Replication.ValueProtobuf> val = msg.values().entrySet().stream().map(e -> {
            Optional value = msg.value((String)e.getKey());
            ImmutableMessage.ValueType type = msg.types().getOrDefault(e.getKey(), ImmutableMessage.ValueType.STRING);
            Replication.ValueProtobuf.ValueType parseType = ProtobufReplicationMessageParser.parseType(type);
            if (parseType == Replication.ValueProtobuf.ValueType.UNRECOGNIZED) {
                logger.warn("Unknown type for key {}, value {}, type {}", new Object[]{e.getKey(), value, type});
            }
            if (parseType.equals((Object)Replication.ValueProtobuf.ValueType.BINARY)) {
                if (value.isPresent()) {
                    ByteString bs = ByteString.copyFrom((byte[])((byte[])value.get()));
                    return new ValueTuple((String)e.getKey(), Replication.ValueProtobuf.newBuilder().setType(parseType).setByteData(bs).build());
                }
                return new ValueTuple((String)e.getKey(), Replication.ValueProtobuf.newBuilder().setType(parseType).setIsNull(true).build());
            }
            String serializeValue = ProtobufReplicationMessageParser.serializeValue(type, value.orElse(null));
            if (serializeValue == null) {
                return new ValueTuple((String)e.getKey(), Replication.ValueProtobuf.newBuilder().setType(Replication.ValueProtobuf.ValueType.CLOCKTIME).setIsNull(value.isEmpty()).build());
            }
            return new ValueTuple((String)e.getKey(), Replication.ValueProtobuf.newBuilder().setValue(serializeValue).setType(parseType).setIsNull(value.isEmpty()).build());
        }).collect(Collectors.toMap(e -> e.key, e -> e.value));
        Replication.ReplicationMessageProtobuf.Builder b = Replication.ReplicationMessageProtobuf.newBuilder().setMagic(12779).addAllPrimarykeys(primaryKeys).setOperation(Replication.ReplicationMessageProtobuf.Operation.valueOf(operation.name())).setTimestamp(timestamp).putAllValues(val);
        if (transactionId != null) {
            b = b.setTransactionId(transactionId);
        }
        HashMap<String, Replication.ReplicationMessageProtobuf> subm = new HashMap<String, Replication.ReplicationMessageProtobuf>();
        if (!msg.subMessageMap().isEmpty()) {
            for (Map.Entry e2 : msg.subMessageMap().entrySet()) {
                subm.put((String)e2.getKey(), ProtobufReplicationMessageParser.toProto((ImmutableMessage)e2.getValue()));
            }
        }
        b = b.putAllSubmessage(subm);
        HashMap<String, Replication.ReplicationMessageListProtobuf> subml = new HashMap<String, Replication.ReplicationMessageListProtobuf>();
        if (!msg.subMessageListMap().isEmpty()) {
            for (Map.Entry e3 : msg.subMessageListMap().entrySet()) {
                Replication.ReplicationMessageListProtobuf.Builder newBuilder = Replication.ReplicationMessageListProtobuf.newBuilder();
                newBuilder.addAllElements(((List)e3.getValue()).stream().map(repl -> ProtobufReplicationMessageParser.toProto(repl)).collect(Collectors.toList()));
                subml.put((String)e3.getKey(), newBuilder.build());
            }
        }
        if (paramMessage.isPresent()) {
            b.setParamMessage(ProtobufReplicationMessageParser.toProto(paramMessage.get()));
        }
        b = b.putAllSubmessageList(subml);
        return b.build();
    }

    public ReplicationMessage parseBytes(Optional<String> source, byte[] data) {
        if (data == null) {
            return null;
        }
        try {
            Replication.ReplicationMessageProtobuf parsed = Replication.ReplicationMessageProtobuf.parseFrom(data);
            return ProtobufReplicationMessageParser.parse(source, parsed, Optional.empty());
        }
        catch (InvalidProtocolBufferException e) {
            logger.error("InvalidProtocolBufferException: ", (Throwable)e);
            return ReplicationFactory.createErrorReplicationMessage((Throwable)e);
        }
    }

    public List<ReplicationMessage> parseMessageList(Optional<String> source, byte[] data) {
        if (data == null) {
            return Collections.emptyList();
        }
        try {
            return Replication.ReplicationMessageListProtobuf.parseFrom(data).getElementsList().stream().map(e -> ProtobufReplicationMessageParser.parse(source, e, Optional.empty())).collect(Collectors.toList());
        }
        catch (InvalidProtocolBufferException e2) {
            logger.error("Error invalid: ", (Throwable)e2);
            return Arrays.asList(ReplicationFactory.createErrorReplicationMessage((Throwable)e2));
        }
    }

    public ReplicationMessage parseStream(Optional<String> source, InputStream data) {
        try {
            return ProtobufReplicationMessageParser.parse(Optional.empty(), Replication.ReplicationMessageProtobuf.parseFrom(data), Optional.empty());
        }
        catch (IOException e) {
            logger.error("Error: ", (Throwable)e);
            return ReplicationFactory.createErrorReplicationMessage((Throwable)e);
        }
    }

    public byte[] serializeMessageList(List<ReplicationMessage> msgs) {
        return Replication.ReplicationMessageListProtobuf.newBuilder().setMagic(12779).addAllElements(msgs.stream().map(msg -> ProtobufReplicationMessageParser.toProto(msg)).collect(Collectors.toList())).build().toByteArray();
    }

    public List<ReplicationMessage> parseMessageList(Optional<String> source, InputStream data) {
        try {
            PushbackInputStream pis = new PushbackInputStream(data, 2);
            byte[] pre = new byte[2];
            int read = pis.read(pre);
            if (read < 2) {
                throw new IllegalArgumentException("Can't parse messaagelist: Insufficient data");
            }
            if ((short)pre[0] != 8) {
                throw new IllegalArgumentException("Bad magic byte: " + (short)pre[0]);
            }
            if ((short)pre[1] != -21) {
                throw new IllegalArgumentException("Bad magic byte" + (short)pre[1]);
            }
            pis.unread(pre);
            return Replication.ReplicationMessageListProtobuf.parseFrom(pis).getElementsList().stream().map(e -> ProtobufReplicationMessageParser.parse(Optional.empty(), e, Optional.empty())).collect(Collectors.toList());
        }
        catch (IOException e2) {
            logger.error("Error: ", (Throwable)e2);
            return Arrays.asList(ReplicationFactory.createErrorReplicationMessage((Throwable)e2));
        }
    }

    public ReplicationMessage parseStream(InputStream data) {
        return this.parseStream(Optional.empty(), data);
    }

    public List<ReplicationMessage> parseMessageList(byte[] data) {
        return this.parseMessageList(Optional.empty(), data);
    }

    static class ValueTuple {
        public final String key;
        public final Replication.ValueProtobuf value;

        public ValueTuple(String key, Replication.ValueProtobuf val) {
            this.key = key;
            this.value = val;
        }
    }
}

