/*
 * Decompiled with CFR 0.152.
 */
package io.floodplain.streams.api;

import io.floodplain.immutable.factory.ImmutableFactory;
import io.floodplain.replication.api.ReplicationMessage;
import java.util.List;
import java.util.function.BiFunction;
import java.util.stream.Collectors;

public class CoreOperators {
    private static final int TOPIC_PARTITION_COUNT = 1;
    private static final int TOPIC_REPLICATION_COUNT = 1;

    private CoreOperators() {
    }

    public static int topicReplicationCount() {
        String env = System.getenv("TOPIC_REPLICATION_COUNT");
        if (env != null) {
            return Integer.parseInt(env);
        }
        return 1;
    }

    public static BiFunction<ReplicationMessage, List<ReplicationMessage>, ReplicationMessage> getListJoinFunctionToParam(boolean skipEmpty) {
        return (message, list) -> {
            if (list.isEmpty() && skipEmpty) {
                return message;
            }
            List withList = list.stream().map(ReplicationMessage::message).collect(Collectors.toList());
            return message.withParamMessage(ImmutableFactory.empty().withSubMessages("list", withList));
        };
    }

    public static String ungroupKey(String key) {
        int index = key.lastIndexOf(124);
        if (index == -1) {
            return key;
        }
        return key.substring(index + 1);
    }

    public static String ungroupKeyReverse(String key) {
        int index = key.indexOf(124);
        if (index == -1) {
            return key;
        }
        return key.substring(0, index);
    }
}

