/*
 * Decompiled with CFR 0.152.
 */
package io.floodplain.streams.api;

import io.floodplain.streams.api.TopologyContext;
import java.util.Objects;

public class Topic {
    private final String topicDefinition;
    private final String qualifiedDefinition;
    private final TopologyContext topologyContext;

    private Topic(TopologyContext topologyContext, String topicDefinition, String qualifiedDefinition) {
        this.topologyContext = topologyContext;
        this.topicDefinition = topicDefinition;
        this.qualifiedDefinition = qualifiedDefinition;
        if (qualifiedDefinition != null && qualifiedDefinition.contains("@")) {
            System.err.println("No");
        }
    }

    public static Topic from(String topicDefinition, TopologyContext topologyContext) {
        return new Topic(topologyContext, topicDefinition, null);
    }

    public static Topic fromQualified(String qualifiedDefinition, TopologyContext topologyContext) {
        return new Topic(topologyContext, null, qualifiedDefinition);
    }

    public String qualifiedString() {
        if (this.qualifiedDefinition != null) {
            return this.qualifiedDefinition;
        }
        return this.topologyContext.topicName(this.topicDefinition);
    }

    public String prefixedString(String prefix) {
        return prefix + "_" + this.qualifiedString();
    }

    public String toString() {
        return this.qualifiedString();
    }

    private String unqualify(String qualified) {
        String[] parts = qualified.split("-");
        if (parts.length < 2) {
            return qualified;
        }
        if (parts.length >= 3) {
            return "@" + parts[parts.length - 1];
        }
        return parts[parts.length - 1];
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Topic)) {
            return false;
        }
        Topic topic = (Topic)o;
        return this.qualifiedString().equals(topic.qualifiedString());
    }

    public int hashCode() {
        return Objects.hash(this.toString());
    }

    public static enum FloodplainKeyFormat {
        CONNECT_KEY_JSON,
        FLOODPLAIN_STRING;

    }

    public static enum FloodplainBodyFormat {
        CONNECT_JSON,
        FLOODPLAIN_JSON;

    }
}

