/*
 * Decompiled with CFR 0.152.
 */
package io.floodplain.streams.api;

import java.util.Optional;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TopologyContext {
    private static final Logger logger = LoggerFactory.getLogger(TopologyContext.class);
    private final Function<String, String> qualifier;

    public static TopologyContext context(Function<String, String> qualifier) {
        return new TopologyContext(qualifier);
    }

    public static TopologyContext context(Optional<String> tenant, Optional<String> deployment, String generation) {
        if (deployment.isPresent() && tenant.isEmpty()) {
            throw new IllegalArgumentException("Can not have a deployment without a deployment: " + tenant + " generation: " + generation);
        }
        return new TopologyContext(new NameQualifier(tenant, deployment, generation));
    }

    public static TopologyContext context(Optional<String> tenant, String generation) {
        return new TopologyContext(new NameQualifier(tenant, Optional.empty(), generation));
    }

    public TopologyContext(Function<String, String> qualifier) {
        this.qualifier = qualifier;
    }

    public String applicationId() {
        return this.topicName("@applicationId");
    }

    public String qualifiedName(String name, int currentTransformer, int currentPipe) {
        return this.topicName("@" + name + "_" + currentPipe + "_" + currentTransformer);
    }

    public String topicName(String topicName) {
        return this.qualifier.apply(topicName);
    }

    private static class NameQualifier
    implements Function<String, String> {
        private final Optional<String> tenant;
        private final Optional<String> deployment;
        private final String generation;

        public NameQualifier(Optional<String> tenant, Optional<String> deployment, String generation) {
            this.tenant = tenant;
            this.deployment = deployment;
            this.generation = generation;
        }

        @Override
        public String apply(String name) {
            if (name.contains(":")) {
                return name;
            }
            long dashCount = name.chars().filter(ch -> ch == 45).count();
            if (dashCount > 1L) {
                logger.warn("Multidash -> This is problematic: {}", (Object)name);
            }
            if (!name.startsWith("@") && name.contains("@")) {
                logger.warn("This is problematic: {}", (Object)name);
                Thread.dumpStack();
            }
            if (name.startsWith("@")) {
                String[] withInstance = name.split(":");
                if (this.tenant.isPresent()) {
                    if (withInstance.length > 1) {
                        return this.tenant.get() + "-" + this.deployment.map(e -> e + "-").orElse("") + this.generation + "-" + withInstance[0].substring(1) + "-" + withInstance[1];
                    }
                    return this.tenant.get() + "-" + this.deployment.map(e -> e + "-").orElse("") + this.generation + "-" + name.substring(1);
                }
                if (withInstance.length > 1) {
                    return this.generation + "-" + withInstance[0].substring(1) + "-" + withInstance[1];
                }
                return this.generation + "-" + name.substring(1);
            }
            return this.tenant.map(s -> s + "-").orElse("") + this.deployment.map(e -> e + "-").orElse("") + name;
        }
    }
}

