/*
 * Decompiled with CFR 0.152.
 */
package io.fluxcapacitor.javaclient.test;

import io.fluxcapacitor.common.Guarantee;
import io.fluxcapacitor.common.ThrowingConsumer;
import io.fluxcapacitor.javaclient.FluxCapacitor;
import io.fluxcapacitor.javaclient.common.ClientUtils;
import io.fluxcapacitor.javaclient.modeling.Id;
import io.fluxcapacitor.javaclient.scheduling.Schedule;
import io.fluxcapacitor.javaclient.test.When;
import io.fluxcapacitor.javaclient.web.HttpRequestMethod;
import io.fluxcapacitor.javaclient.web.WebRequest;
import java.net.HttpCookie;
import java.time.Clock;
import java.time.Duration;
import java.time.Instant;
import java.util.Arrays;
import java.util.UUID;

public interface Given
extends When {
    public Given givenCommands(Object ... var1);

    public Given givenCommandsByUser(Object var1, Object ... var2);

    default public Given givenAppliedEvents(Id<?> aggregateId, Object ... events) {
        return this.givenAppliedEvents(aggregateId.toString(), aggregateId.getType(), events);
    }

    public Given givenAppliedEvents(String var1, Class<?> var2, Object ... var3);

    public Given givenEvents(Object ... var1);

    public Given givenDocument(Object var1);

    default public Given givenDocument(Object document, Object collection) {
        return this.givenDocument(document, UUID.randomUUID().toString(), collection);
    }

    default public Given givenDocument(Object document, Object id, Object collection) {
        return this.givenDocument(document, id, collection, null);
    }

    default public Given givenDocument(Object document, Object id, Object collection, Instant timestamp) {
        return this.givenDocument(document, id, collection, timestamp, timestamp);
    }

    public Given givenDocument(Object var1, Object var2, Object var3, Instant var4, Instant var5);

    public Given givenDocuments(Object var1, Object var2, Object ... var3);

    default public Given givenSchedules(Schedule ... schedules) {
        return this.given((ThrowingConsumer<FluxCapacitor>)((ThrowingConsumer)fc -> Arrays.stream(schedules).forEach(s -> ClientUtils.runSilently(() -> fc.scheduler().schedule(s, false, Guarantee.STORED).get()))));
    }

    default public Given givenScheduledCommands(Schedule ... commands) {
        return this.given((ThrowingConsumer<FluxCapacitor>)((ThrowingConsumer)fc -> Arrays.stream(commands).forEach(s -> fc.scheduler().scheduleCommand(s))));
    }

    default public Given givenExpiredSchedules(Object ... schedules) {
        return this.givenSchedules((Schedule[])Arrays.stream(schedules).map(p -> new Schedule(p, UUID.randomUUID().toString(), this.getCurrentTime())).toArray(Schedule[]::new));
    }

    public Given givenTimeAdvancedTo(Instant var1);

    public Given givenElapsedTime(Duration var1);

    public Given givenWebRequest(WebRequest var1);

    default public Given givenPost(String path, Object payload) {
        return this.givenWebRequest(WebRequest.builder().method(HttpRequestMethod.POST).url(path).payload(payload).build());
    }

    default public Given givenGet(String path) {
        return this.givenWebRequest(WebRequest.builder().method(HttpRequestMethod.GET).url(path).build());
    }

    default public Given givenCookie(String name, String value) {
        return this.givenCookie(new HttpCookie(name, value));
    }

    public Given givenCookie(HttpCookie var1);

    public Given given(ThrowingConsumer<FluxCapacitor> var1);

    public FluxCapacitor getFluxCapacitor();

    default public Clock getClock() {
        return this.getFluxCapacitor().clock();
    }

    default public Instant getCurrentTime() {
        return this.getClock().instant();
    }

    public Given withClock(Clock var1);

    public Given atFixedTime(Instant var1);

    public Given withProperty(String var1, Object var2);

    public Given withBean(Object var1);
}

