/*
 * Decompiled with CFR 0.152.
 */
package io.fluxcapacitor.javaclient.test;

import io.fluxcapacitor.common.reflection.ReflectionUtils;
import io.fluxcapacitor.javaclient.FluxCapacitor;
import io.fluxcapacitor.javaclient.common.Message;
import io.fluxcapacitor.javaclient.scheduling.Schedule;
import io.fluxcapacitor.javaclient.test.FixtureResult;
import io.fluxcapacitor.javaclient.test.GivenWhenThenAssertionError;
import io.fluxcapacitor.javaclient.test.TestFixture;
import io.fluxcapacitor.javaclient.test.Then;
import io.fluxcapacitor.javaclient.web.WebRequest;
import io.fluxcapacitor.javaclient.web.WebResponse;
import java.beans.ConstructorProperties;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.Generated;
import lombok.NonNull;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.hamcrest.Matcher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResultValidator<R>
implements Then<R> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ResultValidator.class);
    static final boolean matchersSupported = ReflectionUtils.classExists((String)"org.hamcrest.Matcher");
    private final TestFixture testFixture;
    private final FluxCapacitor fluxCapacitor;
    private Object result;
    private final List<Message> events;
    private final List<Message> commands;
    private final List<Message> queries;
    private final List<Message> webRequests;
    private final List<Message> webResponses;
    private final List<Message> metrics;
    private final List<Schedule> newSchedules;
    private final List<Schedule> allSchedules;
    private final List<Throwable> errors;

    public ResultValidator(TestFixture testFixture) {
        this.testFixture = testFixture;
        this.fluxCapacitor = testFixture.getFluxCapacitor();
        FixtureResult fixtureResult = testFixture.getFixtureResult();
        this.result = fixtureResult.getResult();
        this.events = fixtureResult.getEvents();
        this.commands = fixtureResult.getCommands();
        this.queries = fixtureResult.getQueries();
        this.webRequests = fixtureResult.getWebRequests();
        this.webResponses = fixtureResult.getWebResponses();
        this.metrics = fixtureResult.getMetrics();
        this.newSchedules = fixtureResult.getSchedules();
        this.allSchedules = testFixture.getFutureSchedules();
        this.errors = fixtureResult.getErrors();
    }

    @Override
    public <MR> Then<MR> mapResult(Function<? super R, ? extends MR> resultMapper) {
        return this.withResult(resultMapper.apply(this.result));
    }

    @Override
    public Then<R> expectEvents(Object ... events) {
        return this.expect(this.asMessages(events), this.events);
    }

    @Override
    public Then<R> expectOnlyEvents(Object ... events) {
        return this.expectOnly(this.asMessages(events), this.events);
    }

    @Override
    public Then<R> expectNoEventsLike(Object ... events) {
        return this.expectNo(this.asMessages(events), this.events);
    }

    @Override
    public Then<R> expectCommands(Object ... commands) {
        return this.expect(this.asMessages(commands), this.commands);
    }

    @Override
    public Then<R> expectOnlyCommands(Object ... commands) {
        return this.expectOnly(this.asMessages(commands), this.commands);
    }

    @Override
    public Then<R> expectNoCommandsLike(Object ... commands) {
        return this.expectNo(this.asMessages(commands), this.commands);
    }

    @Override
    public Then<R> expectQueries(Object ... queries) {
        return this.expect(this.asMessages(queries), this.queries);
    }

    @Override
    public Then<R> expectOnlyQueries(Object ... queries) {
        return this.expectOnly(this.asMessages(queries), this.queries);
    }

    @Override
    public Then<R> expectNoQueriesLike(Object ... queries) {
        return this.expectNo(this.asMessages(queries), this.queries);
    }

    @Override
    public Then<R> expectWebRequests(Object ... webRequests) {
        return this.expect(this.asMessages(webRequests), this.webRequests);
    }

    @Override
    public Then<R> expectOnlyWebRequests(Object ... webRequests) {
        return this.expectOnly(this.asMessages(webRequests), this.webRequests);
    }

    @Override
    public Then<R> expectNoWebRequestsLike(Object ... webRequests) {
        return this.expectNo(this.asMessages(this.webRequests), this.webRequests);
    }

    @Override
    public Then<R> expectWebResponses(Object ... webResponses) {
        return this.expect(this.asMessages(webResponses), this.webResponses);
    }

    @Override
    public Then<R> expectOnlyWebResponses(Object ... webResponses) {
        return this.expectOnly(this.asMessages(webResponses), this.webResponses);
    }

    @Override
    public Then<R> expectNoWebResponsesLike(Object ... webResponses) {
        return this.expectNo(this.asMessages(webResponses), this.webResponses);
    }

    @Override
    public Then<R> expectOnlyNewSchedules(Object ... schedules) {
        return this.expectOnlyScheduledMessages(this.asMessages(schedules), this.newSchedules);
    }

    @Override
    public Then<R> expectNewSchedules(Object ... schedules) {
        return this.expectScheduledMessages(this.asMessages(schedules), this.newSchedules);
    }

    @Override
    public Then<R> expectNoNewSchedulesLike(Object ... schedules) {
        return this.expectNo(this.asMessages(schedules), this.newSchedules);
    }

    @Override
    public Then<R> expectOnlySchedules(Object ... schedules) {
        return this.expectOnlyScheduledMessages(this.asMessages(schedules), this.allSchedules);
    }

    @Override
    public Then<R> expectSchedules(Object ... schedules) {
        return this.expectScheduledMessages(this.asMessages(schedules), this.allSchedules);
    }

    @Override
    public Then<R> expectNoSchedulesLike(Object ... schedules) {
        return this.expectNo(this.asMessages(schedules), this.allSchedules);
    }

    @Override
    public ResultValidator<R> expectResult(Object expectedResult) {
        Class callerClass = ReflectionUtils.getCallerClass();
        return (ResultValidator)this.fluxCapacitor.apply(fc -> {
            Object expected = this.testFixture.parseObject(expectedResult, callerClass);
            Object patt0$temp = this.result;
            if (patt0$temp instanceof Throwable) {
                Throwable e = (Throwable)patt0$temp;
                throw new GivenWhenThenAssertionError("An unexpected exception occurred during handling", expected, this.describeException(e), e);
            }
            if (!this.matches(expected, this.result)) {
                if (this.isComparableToActual(expected)) {
                    throw new GivenWhenThenAssertionError("Handler returned a result of unexpected type", expected.getClass(), this.result.getClass());
                }
                throw new GivenWhenThenAssertionError("Handler returned an unexpected result", expected, this.result);
            }
            return this;
        });
    }

    @Override
    public <M extends Message> Then<R> expectResultMessage(Predicate<M> messagePredicate, String description) {
        Object object = this.result;
        if (object instanceof Throwable) {
            Throwable e = (Throwable)object;
            throw new GivenWhenThenAssertionError("An unexpected exception occurred during handling", description, this.describeException(e), e);
        }
        if (this.result instanceof Message) {
            if (!this.testSafely(messagePredicate, this.result)) {
                if (!this.errors.isEmpty()) {
                    throw new GivenWhenThenAssertionError("Handler returned an unexpected result. Probable cause is an exception during handling.", description, this.describeException(this.errors.getFirst()), this.errors.getFirst());
                }
                throw new GivenWhenThenAssertionError("Handler returned an unexpected result", description, this.result);
            }
            return this;
        }
        throw new GivenWhenThenAssertionError("Test fixture result is not of type Message.", description, this.result);
    }

    @Override
    public <R2 extends R> Then<R2> expectResult(Predicate<R2> predicate, String description) {
        return (Then)this.fluxCapacitor.apply(fc -> {
            Object patt0$temp = this.result;
            if (patt0$temp instanceof Throwable) {
                Throwable e = (Throwable)patt0$temp;
                throw new GivenWhenThenAssertionError("An unexpected exception occurred during handling", e);
            }
            if (!this.matches((Object)predicate, this.result)) {
                if (!this.errors.isEmpty()) {
                    throw new GivenWhenThenAssertionError("Handler returned an unexpected result. Probable cause is an exception during handling.", description, this.describeException(this.errors.getFirst()), this.errors.getFirst());
                }
                throw new GivenWhenThenAssertionError("Handler returned an unexpected result", description, this.result);
            }
            return this;
        });
    }

    @Override
    public ResultValidator<R> expectNoResultLike(Object value) {
        Class callerClass = ReflectionUtils.getCallerClass();
        return (ResultValidator)this.fluxCapacitor.apply(fc -> {
            Object notExpected = this.testFixture.parseObject(value, callerClass);
            if (this.result instanceof Throwable) {
                throw new GivenWhenThenAssertionError("An unexpected exception occurred during handling", (Throwable)this.result);
            }
            if (this.matches(notExpected, this.result)) {
                throw new GivenWhenThenAssertionError(String.format("Handler returned the unwanted result.\nExpected not to get: %s\nGot: %s", notExpected, this.result));
            }
            return this;
        });
    }

    @Override
    @SafeVarargs
    public final <T> Then<R> expectResultContaining(T ... results) {
        if (!(this.result instanceof Collection)) {
            throw new GivenWhenThenAssertionError("Result is not a collection", List.of(results), this.result);
        }
        return this.expect(List.of(results), (Collection)this.result);
    }

    @Override
    public ResultValidator<R> expectExceptionalResult(@NonNull Object expectedException) {
        if (expectedException == null) {
            throw new NullPointerException("expectedException is marked non-null but is null");
        }
        return (ResultValidator)this.fluxCapacitor.apply(fc -> {
            if (!(this.result instanceof Throwable)) {
                throw new GivenWhenThenAssertionError("Handler returned normally but an exception was expected", expectedException, this.result);
            }
            if (!this.matches(expectedException, this.result)) {
                if (this.isComparableToActual(expectedException)) {
                    throw new GivenWhenThenAssertionError("Handler threw unexpected exception", expectedException.getClass(), this.result.getClass());
                }
                throw new GivenWhenThenAssertionError("Handler threw unexpected exception", expectedException, this.result);
            }
            return this;
        });
    }

    @Override
    public <T extends Throwable> Then<R> expectExceptionalResult(Predicate<T> predicate, String description) {
        return (Then)this.fluxCapacitor.apply(fc -> {
            if (!(this.result instanceof Throwable)) {
                throw new GivenWhenThenAssertionError("Handler returned normally but an exception was expected", description, this.result);
            }
            if (!predicate.test((Throwable)this.result)) {
                throw new GivenWhenThenAssertionError("Handler threw unexpected exception", description, this.result);
            }
            return this;
        });
    }

    @Override
    public Then<R> expectError(Object expectedError) {
        if (this.errors.isEmpty()) {
            throw new GivenWhenThenAssertionError("An error was expected but none was published", expectedError, null);
        }
        return this.expect(List.of(expectedError), this.errors);
    }

    @Override
    public <T extends Throwable> Then<R> expectError(Predicate<T> predicate, String description) {
        if (this.errors.isEmpty()) {
            throw new GivenWhenThenAssertionError("An error was expected but none was published", description, null);
        }
        try {
            this.expect(List.of(predicate), this.errors);
        }
        catch (GivenWhenThenAssertionError e) {
            throw new GivenWhenThenAssertionError("An unexpected error was published", description, this.result);
        }
        return this;
    }

    @Override
    public Then<R> expectNoErrors() {
        if (!this.errors.isEmpty()) {
            throw new GivenWhenThenAssertionError("An unexpected exception occurred during handling", this.errors.getFirst());
        }
        return this;
    }

    @Override
    public Then<R> expectMetrics(Object ... metrics) {
        return this.expect(this.asMessages(metrics), this.metrics);
    }

    @Override
    public Then<R> expectOnlyMetrics(Object ... metrics) {
        return this.expectOnly(this.asMessages(metrics), this.metrics);
    }

    @Override
    public Then<R> expectNoMetricsLike(Object ... metrics) {
        return this.expectNo(this.asMessages(metrics), this.metrics);
    }

    @Override
    public ResultValidator<R> expectThat(Consumer<FluxCapacitor> check) {
        return (ResultValidator)this.fluxCapacitor.apply(fc -> {
            try {
                check.accept((FluxCapacitor)fc);
            }
            catch (Throwable e) {
                if (!this.errors.isEmpty()) {
                    throw new GivenWhenThenAssertionError(String.format("Verify check failed: %s\nProbable cause is an exception during handling.", e.getMessage()), "Successful check", this.describeException(e), this.errors.getFirst());
                }
                throw new GivenWhenThenAssertionError("Verify check failed", "Successful check", this.describeException(e), e);
            }
            return this;
        });
    }

    @Override
    public Then<R> expectTrue(Predicate<FluxCapacitor> check) {
        return (Then)this.fluxCapacitor.apply(fc -> {
            if (!check.test((FluxCapacitor)fc)) {
                throw new GivenWhenThenAssertionError("Predicate test failed");
            }
            return this;
        });
    }

    @Override
    public TestFixture andThen() {
        return this.testFixture.reset();
    }

    protected boolean isComparableToActual(Object expected) {
        return !(this.result == null || expected == null || this.isMatcher(expected) || expected instanceof Collection && this.result instanceof Collection || expected instanceof Map && this.result instanceof Map || Objects.equals(expected.getClass(), this.result.getClass()));
    }

    protected ResultValidator<R> expectScheduledMessages(Collection<?> expected, Collection<? extends Schedule> actual) {
        return (ResultValidator)this.fluxCapacitor.apply(fc -> {
            if (!expected.isEmpty() && actual.isEmpty()) {
                throw new GivenWhenThenAssertionError("No messages were scheduled");
            }
            expected.forEach(e -> {
                if (e instanceof Schedule && actual.stream().noneMatch(s -> Objects.equals(s.getDeadline(), ((Schedule)e).getDeadline()))) {
                    throw new GivenWhenThenAssertionError("Found no schedules with matching deadline", ((Schedule)e).getDeadline(), actual.stream().map(Schedule::getDeadline).collect(Collectors.toList()));
                }
            });
            return this.expect(this.asMessages(expected), actual);
        });
    }

    protected ResultValidator<R> expect(Collection<?> expected, Collection<?> actual) {
        return (ResultValidator)this.fluxCapacitor.apply(fc -> {
            if (!this.containsAll(expected, actual)) {
                ArrayList remaining = new ArrayList(actual);
                List filtered = expected.stream().flatMap(e -> {
                    if (e != null && !this.isMatcher(expected) && !(expected instanceof Predicate)) {
                        Class<?> payloadType = e instanceof Message ? ((Message)e).getPayload().getClass() : expected.getClass();
                        Object match = remaining.stream().filter(a -> payloadType.equals(a instanceof Message ? ((Message)a).getPayload().getClass() : a.getClass())).findFirst().orElse(null);
                        if (match != null) {
                            remaining.remove(match);
                            return Stream.of(match);
                        }
                    }
                    return Stream.empty();
                }).collect(Collectors.toList());
                this.reportMismatch(expected, filtered.size() == expected.size() ? filtered : actual);
            }
            return this;
        });
    }

    protected ResultValidator<R> expectOnly(Collection<?> expected, Collection<?> actual) {
        return (ResultValidator)this.fluxCapacitor.apply(fc -> {
            if (expected.size() != actual.size()) {
                this.reportMismatch(expected, actual);
            } else if (!this.containsAll(expected, actual)) {
                this.reportMismatch(expected, actual);
            }
            return this;
        });
    }

    protected ResultValidator<R> expectNo(Collection<?> expectedNotToGet, Collection<?> actual) {
        return (ResultValidator)this.fluxCapacitor.apply(fc -> {
            if (this.containsAny(expectedNotToGet, actual)) {
                this.reportUnwantedMatch(expectedNotToGet, actual);
            }
            return this;
        });
    }

    protected void reportMismatch(Collection<?> expected, Collection<?> actual) {
        this.fluxCapacitor.apply(fc -> {
            if (!(this.errors.isEmpty() || !actual.isEmpty() && this.errors.containsAll(actual))) {
                throw new GivenWhenThenAssertionError("Published messages did not match. Probable cause is an exception that occurred during handling", expected, actual, this.errors.getFirst());
            }
            throw new GivenWhenThenAssertionError("Published messages did not match", expected, actual);
        });
    }

    protected void reportUnwantedMatch(Collection<?> expected, Collection<?> actual) {
        this.fluxCapacitor.apply(fc -> {
            if (!(this.errors.isEmpty() || !actual.isEmpty() && this.errors.containsAll(actual))) {
                throw new GivenWhenThenAssertionError("An unexpected exception occurred during handling", this.errors.getFirst());
            }
            throw new GivenWhenThenAssertionError(String.format("Unwanted match found in published messages.\nExpected not to get: %s\nGot: %s\n", expected, actual), expected, actual);
        });
    }

    protected ResultValidator<R> expectOnlyScheduledMessages(Collection<?> expected, Collection<? extends Schedule> actual) {
        ResultValidator<R> result = this.expectScheduledMessages(expected, actual);
        return result.expectOnly(expected, actual);
    }

    protected boolean containsAll(Collection<?> expected, Collection<?> actual) {
        return expected.stream().allMatch(e -> actual.stream().anyMatch(a -> this.matches(e, a)));
    }

    protected boolean containsAny(Collection<?> expected, Collection<?> actual) {
        return expected.stream().anyMatch(e -> actual.stream().anyMatch(a -> this.matches(e, a)));
    }

    protected boolean matches(Object expected, Object actual) {
        if (actual instanceof Message) {
            return this.matches(expected, (Message)actual);
        }
        if (expected instanceof Predicate) {
            return this.testSafely((Predicate)expected, actual);
        }
        if (this.isMatcher(expected)) {
            return ((Matcher)expected).matches(actual);
        }
        if (expected instanceof Class) {
            return actual instanceof Class ? expected.equals(actual) : ((Class)expected).isInstance(actual);
        }
        return Objects.deepEquals(expected, actual);
    }

    protected boolean matches(Object expected, Message actual) {
        if (expected instanceof Predicate) {
            return this.testSafely((Predicate)expected, actual.getPayload()) || this.testSafely((Predicate)expected, actual);
        }
        if (this.isMatcher(expected)) {
            return ((Matcher)expected).matches(actual.getPayload()) || ((Matcher)expected).matches((Object)actual);
        }
        if (expected instanceof Class) {
            return ((Class)expected).isInstance(actual.getPayload());
        }
        Message expectedMessage = Message.asMessage((Object)expected);
        if (actual instanceof Schedule && expected instanceof Schedule && !Objects.equals(((Schedule)expected).getDeadline(), ((Schedule)actual).getDeadline())) {
            return false;
        }
        if (actual instanceof WebRequest && expected instanceof WebRequest && !Objects.equals(((WebRequest)expected).getMethod(), ((WebRequest)actual).getMethod())) {
            return false;
        }
        if (actual instanceof WebResponse) {
            WebResponse response = (WebResponse)actual;
            if (!(expected instanceof Message)) {
                Class expectedType = expectedMessage.getPayloadClass();
                if (!response.getPayloadClass().equals(expectedType)) {
                    return new EqualsBuilder().append(expected, response.getPayloadAs(expectedType)).isEquals();
                }
            }
        }
        if (!actual.getMetadata().entrySet().containsAll(expectedMessage.getMetadata().entrySet())) {
            return false;
        }
        return new EqualsBuilder().append(expectedMessage.getPayload(), actual.getPayload()).isEquals();
    }

    protected Collection<?> asMessages(Object ... expectedMessages) {
        Class callerClass = ReflectionUtils.getCallerClass();
        return (Collection)this.fluxCapacitor.apply(fc -> Arrays.stream(expectedMessages).flatMap(e -> e instanceof Collection ? ((Collection)e).stream() : Stream.of(e)).map(c -> this.testFixture.parseObject(c, callerClass)).map(e -> e instanceof Message || e instanceof Predicate || this.isMatcher(e) || e instanceof Class ? e : new Message(e)).collect(Collectors.toList()));
    }

    protected boolean testSafely(Predicate<?> predicate, Object actual) {
        try {
            return predicate.test(actual);
        }
        catch (ClassCastException e) {
            return false;
        }
        catch (NullPointerException e) {
            if (actual == null) {
                return false;
            }
            throw e;
        }
    }

    protected boolean isMatcher(Object expected) {
        return matchersSupported && expected instanceof Matcher;
    }

    protected String describeException(Throwable e) {
        return Optional.ofNullable(e.getMessage()).map(m -> "%s: %s".formatted(e.getClass().getSimpleName(), m)).orElseGet(() -> e.getClass().getSimpleName());
    }

    @ConstructorProperties(value={"testFixture", "fluxCapacitor", "result", "events", "commands", "queries", "webRequests", "webResponses", "metrics", "newSchedules", "allSchedules", "errors"})
    @Generated
    public ResultValidator(TestFixture testFixture, FluxCapacitor fluxCapacitor, Object result, List<Message> events, List<Message> commands, List<Message> queries, List<Message> webRequests, List<Message> webResponses, List<Message> metrics, List<Schedule> newSchedules, List<Schedule> allSchedules, List<Throwable> errors) {
        this.testFixture = testFixture;
        this.fluxCapacitor = fluxCapacitor;
        this.result = result;
        this.events = events;
        this.commands = commands;
        this.queries = queries;
        this.webRequests = webRequests;
        this.webResponses = webResponses;
        this.metrics = metrics;
        this.newSchedules = newSchedules;
        this.allSchedules = allSchedules;
        this.errors = errors;
    }

    @Generated
    protected FluxCapacitor getFluxCapacitor() {
        return this.fluxCapacitor;
    }

    @Generated
    public ResultValidator<R> withResult(Object result) {
        return this.result == result ? this : new ResultValidator<R>(this.testFixture, this.fluxCapacitor, result, this.events, this.commands, this.queries, this.webRequests, this.webResponses, this.metrics, this.newSchedules, this.allSchedules, this.errors);
    }
}

