/*
 * Decompiled with CFR 0.152.
 */
package io.fluxcapacitor.javaclient.common.metrics;

import io.fluxcapacitor.common.Registration;
import io.fluxcapacitor.javaclient.FluxCapacitor;
import io.fluxcapacitor.javaclient.common.metrics.ApplicationMetricsEvent;
import java.beans.ConstructorProperties;
import java.lang.management.ManagementFactory;
import java.time.Duration;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ApplicationMonitor {
    private static final Logger log = LoggerFactory.getLogger(ApplicationMonitor.class);
    private final FluxCapacitor fluxCapacitor;
    private final ScheduledExecutorService scheduler = Executors.newSingleThreadScheduledExecutor();

    public static Registration start(FluxCapacitor fluxCapacitor, Duration period) {
        ApplicationMonitor applicationMonitor = new ApplicationMonitor(fluxCapacitor);
        applicationMonitor.start(period);
        return applicationMonitor::stop;
    }

    protected void start(Duration period) {
        long delay = period.toMillis();
        this.scheduler.scheduleWithFixedDelay(this::registerMetrics, delay, delay, TimeUnit.MILLISECONDS);
    }

    protected void registerMetrics() {
        ApplicationMetricsEvent metrics;
        try {
            double cpu = ManagementFactory.getOperatingSystemMXBean().getSystemLoadAverage();
            long memory = ManagementFactory.getMemoryMXBean().getHeapMemoryUsage().getUsed();
            int threadCount = ManagementFactory.getThreadMXBean().getThreadCount();
            double garbageCollectionTimeAverage = ManagementFactory.getGarbageCollectorMXBeans().stream().mapToDouble(bean -> bean.getCollectionCount() > 0L ? (double)bean.getCollectionTime() / (double)bean.getCollectionCount() : 0.0).filter(avg -> avg > 0.0).average().orElse(0.0);
            metrics = new ApplicationMetricsEvent(this.fluxCapacitor.client().name(), this.fluxCapacitor.client().id(), cpu, memory, threadCount, garbageCollectionTimeAverage);
        }
        catch (Exception e) {
            log.error("Failed to collect application metrics. Stopping application monitor.", (Throwable)e);
            this.stop();
            throw e;
        }
        try {
            this.fluxCapacitor.metricsGateway().publish(metrics);
        }
        catch (Exception e) {
            log.error("Failed to publish application metrics", (Throwable)e);
        }
    }

    protected void stop() {
        this.scheduler.shutdownNow();
    }

    @ConstructorProperties(value={"fluxCapacitor"})
    protected ApplicationMonitor(FluxCapacitor fluxCapacitor) {
        this.fluxCapacitor = fluxCapacitor;
    }
}

