/*
 * Decompiled with CFR 0.152.
 */
package io.fluxcapacitor.javaclient.common.model;

import io.fluxcapacitor.common.api.Metadata;
import io.fluxcapacitor.javaclient.common.Message;
import io.fluxcapacitor.javaclient.common.model.DefaultLegalCheck;
import java.util.function.Function;
import java.util.function.Predicate;

public interface Model<T> {
    default public <E extends Exception> Model<T> assertLegal(Object command) throws E {
        DefaultLegalCheck.assertLegal(command, this);
        return this;
    }

    default public <E extends Exception> Model<T> assertThat(Validator<T, E> validator) throws E {
        validator.validate(this.get());
        return this;
    }

    default public <E extends Exception> Model<T> ensure(Predicate<T> check, Function<T, E> errorProvider) throws E {
        if (!check.test(this.get())) {
            throw (Exception)errorProvider.apply(this.get());
        }
        return this;
    }

    default public Model<T> apply(Object event) {
        return this.apply(new Message(event));
    }

    default public Model<T> apply(Object event, Metadata metadata) {
        return this.apply(new Message(event, metadata));
    }

    public Model<T> apply(Message var1);

    default public Model<T> apply(Function<T, Message> eventFunction) {
        return this.apply(eventFunction.apply(this.get()));
    }

    public T get();

    public long getSequenceNumber();

    @FunctionalInterface
    public static interface Validator<T, E extends Exception> {
        public void validate(T var1) throws E;
    }
}

