/*
 * Decompiled with CFR 0.152.
 */
package io.fluxcapacitor.javaclient.common.serialization.upcasting;

import io.fluxcapacitor.common.api.Data;
import io.fluxcapacitor.common.api.SerializedObject;
import io.fluxcapacitor.common.reflection.ReflectionUtils;
import io.fluxcapacitor.javaclient.common.serialization.SerializationException;
import io.fluxcapacitor.javaclient.common.serialization.upcasting.AnnotatedUpcaster;
import io.fluxcapacitor.javaclient.common.serialization.upcasting.Upcast;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Stream;

public class UpcastInspector {
    private static final Comparator<AnnotatedUpcaster<?>> upcasterComparator = Comparator.comparing(u -> u.getAnnotation().revision()).thenComparing(u -> u.getAnnotation().type());

    public static boolean hasAnnotatedMethods(Class<?> type) {
        return ReflectionUtils.getAllMethods(type).anyMatch(m -> m.isAnnotationPresent(Upcast.class));
    }

    public static <T> List<AnnotatedUpcaster<T>> inspect(Collection<?> upcasters, Class<T> dataType) {
        ArrayList result = new ArrayList();
        for (Object upcaster : upcasters) {
            ReflectionUtils.getAllMethods(upcaster.getClass()).filter(m -> m.isAnnotationPresent(Upcast.class)).forEach(m -> result.add(UpcastInspector.createUpcaster(m, upcaster, dataType)));
        }
        result.sort(upcasterComparator);
        return result;
    }

    private static <T> AnnotatedUpcaster<T> createUpcaster(Method method, Object target, Class<T> dataType) {
        if (method.getReturnType().equals(Void.TYPE)) {
            return new AnnotatedUpcaster(method, i -> Stream.empty());
        }
        method = (Method)ReflectionUtils.ensureAccessible((AccessibleObject)method);
        Function invokeFunction = UpcastInspector.invokeFunction(method, target, dataType);
        BiFunction resultMapper = UpcastInspector.mapResult(method, dataType);
        return new AnnotatedUpcaster(method, d -> (Stream)resultMapper.apply((SerializedObject)d, () -> invokeFunction.apply((SerializedObject)d)));
    }

    private static <T> Function<SerializedObject<T, ?>, Object> invokeFunction(Method method, Object target, Class<T> dataType) {
        Type[] parameters = method.getGenericParameterTypes();
        if (parameters.length != 1) {
            throw new SerializationException(String.format("Upcaster method '%s' has unexpected number of parameters. Expected 1 or 0.", method));
        }
        if (parameters[0] instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)parameters[0];
            if (parameterizedType.getRawType().equals(Data.class) && dataType.isAssignableFrom((Class)parameterizedType.getActualTypeArguments()[0])) {
                return s -> UpcastInspector.invokeMethod(method, s.data(), target);
            }
            if (dataType.isAssignableFrom((Class)parameterizedType.getRawType())) {
                return s -> UpcastInspector.invokeMethod(method, s.data().getValue(), target);
            }
        } else if (dataType.isAssignableFrom((Class)parameters[0])) {
            return s -> UpcastInspector.invokeMethod(method, s.data().getValue(), target);
        }
        throw new SerializationException(String.format("First parameter in upcaster method '%s' is of unexpected type. Expected Data<%s> or %s.", method, dataType.getName(), dataType.getName()));
    }

    private static Object invokeMethod(Method method, Object argument, Object target) {
        try {
            return method.invoke(target, argument);
        }
        catch (IllegalAccessException e) {
            throw new SerializationException("Not allowed to invoke method: " + method, e);
        }
        catch (InvocationTargetException e) {
            throw new SerializationException("Exception while upcasting using method: " + method, e);
        }
    }

    private static <T> BiFunction<SerializedObject<T, ?>, Supplier<Object>, Stream<SerializedObject<T, ?>>> mapResult(Method method, Class<T> dataType) {
        if (dataType.isAssignableFrom(method.getReturnType())) {
            Upcast annotation = method.getAnnotation(Upcast.class);
            return (s, o) -> Stream.of(s.withData(new Data(o, annotation.type(), annotation.revision() + 1)));
        }
        if (method.getReturnType().equals(Data.class)) {
            return (s, o) -> Stream.of(s.withData((Data)o.get()));
        }
        if (method.getReturnType().equals(Optional.class)) {
            ParameterizedType parameterizedType = (ParameterizedType)method.getGenericReturnType();
            if (parameterizedType.getActualTypeArguments()[0] instanceof Class) {
                Class typeParameter = (Class)parameterizedType.getActualTypeArguments()[0];
                if (dataType.isAssignableFrom(typeParameter)) {
                    Upcast annotation = method.getAnnotation(Upcast.class);
                    return (s, o) -> {
                        Optional result = (Optional)o.get();
                        return result.map(t -> Stream.of(s.withData(new Data(t, annotation.type(), annotation.revision() + 1)))).orElseGet(Stream::empty);
                    };
                }
            } else if (parameterizedType.getActualTypeArguments()[0] instanceof ParameterizedType && ((ParameterizedType)parameterizedType.getActualTypeArguments()[0]).getRawType().equals(Data.class)) {
                return (s, o) -> ((Optional)o.get()).map(d -> Stream.of(s.withData(d))).orElse(Stream.empty());
            }
        }
        if (method.getReturnType().equals(Stream.class)) {
            return (s, o) -> ((Stream)o.get()).map(arg_0 -> ((SerializedObject)s).withData(arg_0));
        }
        throw new SerializationException(String.format("Unexpected return type of upcaster method '%s'. Expected Data<%s>, %s, Optional<Data<%s>>, Optional<%s>, Stream<Data<%s>> or void", method, dataType.getName(), dataType.getName(), dataType.getName(), dataType.getName(), dataType.getName()));
    }
}

