/*
 * Decompiled with CFR 0.152.
 */
package io.fluxcapacitor.javaclient.eventsourcing;

import java.beans.ConstructorProperties;
import java.util.function.UnaryOperator;

public final class Aggregate<T> {
    private final String id;
    private final long sequenceNumber;
    private final T model;

    public Aggregate<T> update(UnaryOperator<T> updateFunction) {
        return new Aggregate(this.id, this.sequenceNumber + 1L, updateFunction.apply(this.model));
    }

    @ConstructorProperties(value={"id", "sequenceNumber", "model"})
    public Aggregate(String id, long sequenceNumber, T model) {
        this.id = id;
        this.sequenceNumber = sequenceNumber;
        this.model = model;
    }

    public String getId() {
        return this.id;
    }

    public long getSequenceNumber() {
        return this.sequenceNumber;
    }

    public T getModel() {
        return this.model;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Aggregate)) {
            return false;
        }
        Aggregate other = (Aggregate)o;
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        if (this.getSequenceNumber() != other.getSequenceNumber()) {
            return false;
        }
        T this$model = this.getModel();
        T other$model = other.getModel();
        return !(this$model == null ? other$model != null : !this$model.equals(other$model));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        long $sequenceNumber = this.getSequenceNumber();
        result = result * 59 + (int)($sequenceNumber >>> 32 ^ $sequenceNumber);
        T $model = this.getModel();
        result = result * 59 + ($model == null ? 43 : $model.hashCode());
        return result;
    }

    public String toString() {
        return "Aggregate(id=" + this.getId() + ", sequenceNumber=" + this.getSequenceNumber() + ", model=" + this.getModel() + ")";
    }
}

