/*
 * Decompiled with CFR 0.152.
 */
package io.fluxcapacitor.javaclient.eventsourcing;

import io.fluxcapacitor.common.api.tracking.MessageBatch;
import io.fluxcapacitor.javaclient.eventsourcing.EventSourcing;
import io.fluxcapacitor.javaclient.tracking.BatchInterceptor;
import io.fluxcapacitor.javaclient.tracking.Tracker;
import java.beans.ConstructorProperties;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CacheInvalidatingInterceptor
implements BatchInterceptor {
    private static final Logger log = LoggerFactory.getLogger(CacheInvalidatingInterceptor.class);
    private final EventSourcing eventSourcing;
    private int[] lastSegment;

    @Override
    public Consumer<MessageBatch> intercept(Consumer<MessageBatch> consumer, Tracker tracker) {
        return batch -> {
            if (this.shouldInvalidateCache(batch.getSegment())) {
                log.info("Consumer segment changed. Invalidating event model caches.");
                try {
                    this.eventSourcing.invalidateCache();
                }
                catch (Exception e) {
                    log.error("Failed to invalidate event model cache", (Throwable)e);
                }
            }
            if (batch.getSegment()[0] != batch.getSegment()[1]) {
                this.lastSegment = batch.getSegment();
            }
            consumer.accept((MessageBatch)batch);
        };
    }

    private boolean shouldInvalidateCache(int[] newSegment) {
        return this.lastSegment != null && newSegment[0] != newSegment[1] && (newSegment[0] > this.lastSegment[0] || newSegment[1] < this.lastSegment[1]);
    }

    @ConstructorProperties(value={"eventSourcing"})
    public CacheInvalidatingInterceptor(EventSourcing eventSourcing) {
        this.eventSourcing = eventSourcing;
    }
}

