/*
 * Decompiled with CFR 0.152.
 */
package io.fluxcapacitor.javaclient.common;

import java.time.Duration;
import java.time.Instant;
import java.util.Collection;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ClientUtils {
    private static final Logger log = LoggerFactory.getLogger(ClientUtils.class);

    public static void waitForResults(Duration maxDuration, Collection<? extends CompletableFuture<?>> futures) {
        Instant deadline = Instant.now().plus(maxDuration);
        for (CompletableFuture<?> f : futures) {
            try {
                f.get(Math.max(0L, Duration.between(Instant.now(), deadline).toMillis()), TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                log.warn("Thread was interrupted before receiving all expected results", (Throwable)e);
                return;
            }
            catch (TimeoutException e) {
                log.warn("Timed out before having received all expected results", (Throwable)e);
                return;
            }
            catch (ExecutionException executionException) {
            }
        }
    }

    private ClientUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

