/*
 * Decompiled with CFR 0.152.
 */
package io.fluxcapacitor.javaclient.common;

import com.fasterxml.jackson.annotation.JsonTypeInfo;
import io.fluxcapacitor.common.api.Metadata;
import io.fluxcapacitor.javaclient.common.IdentityProvider;
import io.fluxcapacitor.javaclient.common.UuidFactory;
import java.beans.ConstructorProperties;
import java.time.Clock;
import java.time.Instant;

@JsonTypeInfo(use=JsonTypeInfo.Id.CLASS)
public final class Message {
    private static final ThreadLocal<Clock> clock = ThreadLocal.withInitial(Clock::systemUTC);
    public static IdentityProvider identityProvider = new UuidFactory();
    @JsonTypeInfo(use=JsonTypeInfo.Id.CLASS)
    private final Object payload;
    private final Metadata metadata;
    private final String messageId;
    private final Instant timestamp;

    public Message(Object payload) {
        this(payload, Metadata.empty(), identityProvider.nextId(), clock.get().instant());
    }

    public Message(Object payload, Metadata metadata) {
        this(payload, metadata, identityProvider.nextId(), clock.get().instant());
    }

    public <R> R getPayload() {
        return (R)this.payload;
    }

    public static void useCustomClock(Clock customClock) {
        clock.set(customClock);
    }

    public static void useDefaultClock() {
        clock.set(Clock.systemUTC());
    }

    public Metadata getMetadata() {
        return this.metadata;
    }

    public String getMessageId() {
        return this.messageId;
    }

    public Instant getTimestamp() {
        return this.timestamp;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Message)) {
            return false;
        }
        Message other = (Message)o;
        Object this$payload = this.getPayload();
        Object other$payload = other.getPayload();
        if (this$payload == null ? other$payload != null : !this$payload.equals(other$payload)) {
            return false;
        }
        Metadata this$metadata = this.getMetadata();
        Metadata other$metadata = other.getMetadata();
        if (this$metadata == null ? other$metadata != null : !this$metadata.equals(other$metadata)) {
            return false;
        }
        String this$messageId = this.getMessageId();
        String other$messageId = other.getMessageId();
        if (this$messageId == null ? other$messageId != null : !this$messageId.equals(other$messageId)) {
            return false;
        }
        Instant this$timestamp = this.getTimestamp();
        Instant other$timestamp = other.getTimestamp();
        return !(this$timestamp == null ? other$timestamp != null : !((Object)this$timestamp).equals(other$timestamp));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Object $payload = this.getPayload();
        result = result * 59 + ($payload == null ? 43 : $payload.hashCode());
        Metadata $metadata = this.getMetadata();
        result = result * 59 + ($metadata == null ? 43 : $metadata.hashCode());
        String $messageId = this.getMessageId();
        result = result * 59 + ($messageId == null ? 43 : $messageId.hashCode());
        Instant $timestamp = this.getTimestamp();
        result = result * 59 + ($timestamp == null ? 43 : ((Object)$timestamp).hashCode());
        return result;
    }

    public String toString() {
        return "Message(payload=" + this.getPayload() + ", metadata=" + this.getMetadata() + ", messageId=" + this.getMessageId() + ", timestamp=" + this.getTimestamp() + ")";
    }

    @ConstructorProperties(value={"payload", "metadata", "messageId", "timestamp"})
    public Message(Object payload, Metadata metadata, String messageId, Instant timestamp) {
        this.payload = payload;
        this.metadata = metadata;
        this.messageId = messageId;
        this.timestamp = timestamp;
    }

    public Message withPayload(Object payload) {
        return this.payload == payload ? this : new Message(payload, this.metadata, this.messageId, this.timestamp);
    }

    public Message withMetadata(Metadata metadata) {
        return this.metadata == metadata ? this : new Message(this.payload, metadata, this.messageId, this.timestamp);
    }
}

