/*
 * Decompiled with CFR 0.152.
 */
package io.fluxcapacitor.javaclient.common.serialization;

import io.fluxcapacitor.common.api.Data;
import io.fluxcapacitor.common.api.SerializedObject;
import io.fluxcapacitor.common.serialization.Revision;
import io.fluxcapacitor.javaclient.common.serialization.DeserializingObject;
import io.fluxcapacitor.javaclient.common.serialization.SerializationException;
import io.fluxcapacitor.javaclient.common.serialization.Serializer;
import io.fluxcapacitor.javaclient.common.serialization.upcasting.Upcaster;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractSerializer
implements Serializer {
    private static final Logger log = LoggerFactory.getLogger(AbstractSerializer.class);
    private final Upcaster<SerializedObject<byte[], ?>> upcasterChain;

    protected AbstractSerializer(Upcaster<SerializedObject<byte[], ?>> upcasterChain) {
        this.upcasterChain = upcasterChain;
    }

    @Override
    public Data<byte[]> serialize(Object object) {
        byte[] bytes;
        try {
            bytes = this.doSerialize(object);
        }
        catch (Exception e) {
            throw new SerializationException("Could not serialize " + object, e);
        }
        Revision revision = this.getRevision(object);
        return new Data((Object)bytes, this.getObjectType(object), revision == null ? 0 : revision.value());
    }

    protected String getObjectType(Object object) {
        return object == null ? Void.class.getName() : object.getClass().getName();
    }

    protected Revision getRevision(Object object) {
        return object == null ? null : object.getClass().getAnnotation(Revision.class);
    }

    protected abstract byte[] doSerialize(Object var1) throws Exception;

    public <S extends SerializedObject<byte[], S>> Stream<DeserializingObject<byte[], S>> deserialize(Stream<S> dataStream, boolean failOnUnknownType) {
        return this.upcasterChain.upcast(dataStream).flatMap(s -> {
            Class<?> type;
            try {
                type = this.classForType(s.data().getType());
            }
            catch (Exception e) {
                if (failOnUnknownType) {
                    throw new SerializationException(String.format("Could not deserialize object. The serialized type is unknown: %s (rev. %d)", s.data().getType(), s.data().getRevision()), e);
                }
                return this.handleUnknownType((SerializedObject<byte[], ?>)s);
            }
            return Stream.of(new DeserializingObject((SerializedObject)s, () -> {
                try {
                    return this.doDeserialize((byte[])s.data().getValue(), type);
                }
                catch (Exception e) {
                    throw new SerializationException("Could not deserialize a " + s.data().getType(), e);
                }
            }));
        });
    }

    protected Class<?> classForType(String type) throws Exception {
        return Class.forName(type);
    }

    protected Stream<DeserializingObject<byte[], ?>> handleUnknownType(SerializedObject<byte[], ?> serializedObject) {
        return Stream.empty();
    }

    protected abstract Object doDeserialize(byte[] var1, Class<?> var2) throws Exception;

    protected static enum NullValue {
        INSTANCE;

    }
}

