/*
 * Decompiled with CFR 0.152.
 */
package io.fluxcapacitor.javaclient.configuration.client;

import io.fluxcapacitor.common.MessageType;
import io.fluxcapacitor.javaclient.common.serialization.compression.CompressionAlgorithm;
import io.fluxcapacitor.javaclient.common.websocket.ServiceUrlBuilder;
import io.fluxcapacitor.javaclient.configuration.client.AbstractClient;
import io.fluxcapacitor.javaclient.eventsourcing.client.EventStoreClient;
import io.fluxcapacitor.javaclient.eventsourcing.client.WebSocketEventStoreClient;
import io.fluxcapacitor.javaclient.keyvalue.client.KeyValueClient;
import io.fluxcapacitor.javaclient.keyvalue.client.WebsocketKeyValueClient;
import io.fluxcapacitor.javaclient.publishing.client.GatewayClient;
import io.fluxcapacitor.javaclient.publishing.client.WebsocketGatewayClient;
import io.fluxcapacitor.javaclient.scheduling.client.SchedulingClient;
import io.fluxcapacitor.javaclient.scheduling.client.WebsocketSchedulingClient;
import io.fluxcapacitor.javaclient.tracking.client.TrackingClient;
import io.fluxcapacitor.javaclient.tracking.client.WebsocketTrackingClient;
import java.beans.ConstructorProperties;
import java.util.UUID;
import java.util.function.Function;
import lombok.NonNull;

public class WebSocketClient
extends AbstractClient {
    public static WebSocketClient newInstance(Properties properties) {
        return new WebSocketClient(properties.getName(), properties.getId(), type -> new WebsocketGatewayClient(ServiceUrlBuilder.producerUrl(type, properties), properties), type -> new WebsocketTrackingClient(ServiceUrlBuilder.consumerUrl(type, properties), properties), new WebSocketEventStoreClient(ServiceUrlBuilder.eventSourcingUrl(properties), properties), new WebsocketSchedulingClient(ServiceUrlBuilder.schedulingUrl(properties), properties), new WebsocketKeyValueClient(ServiceUrlBuilder.keyValueUrl(properties), properties));
    }

    private WebSocketClient(String name, String id, Function<MessageType, ? extends GatewayClient> gatewayClients, Function<MessageType, ? extends TrackingClient> trackingClients, EventStoreClient eventStoreClient, SchedulingClient schedulingClient, KeyValueClient keyValueClient) {
        super(name, id, gatewayClients, trackingClients, eventStoreClient, schedulingClient, keyValueClient);
    }

    @Override
    public void shutDown() {
        super.shutDown();
        try {
            Thread.sleep(100L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public static final class Properties {
        @NonNull
        private final String serviceBaseUrl;
        @NonNull
        private final String name;
        @NonNull
        private final String id;
        private final CompressionAlgorithm compression;
        private final String projectId;
        private final String typeFilter;

        private static String $default$id() {
            return UUID.randomUUID().toString();
        }

        private static CompressionAlgorithm $default$compression() {
            return CompressionAlgorithm.LZ4;
        }

        @ConstructorProperties(value={"serviceBaseUrl", "name", "id", "compression", "projectId", "typeFilter"})
        Properties(@NonNull String serviceBaseUrl, @NonNull String name, @NonNull String id, CompressionAlgorithm compression, String projectId, String typeFilter) {
            if (serviceBaseUrl == null) {
                throw new NullPointerException("serviceBaseUrl is marked non-null but is null");
            }
            if (name == null) {
                throw new NullPointerException("name is marked non-null but is null");
            }
            if (id == null) {
                throw new NullPointerException("id is marked non-null but is null");
            }
            this.serviceBaseUrl = serviceBaseUrl;
            this.name = name;
            this.id = id;
            this.compression = compression;
            this.projectId = projectId;
            this.typeFilter = typeFilter;
        }

        public static PropertiesBuilder builder() {
            return new PropertiesBuilder();
        }

        public PropertiesBuilder toBuilder() {
            return new PropertiesBuilder().serviceBaseUrl(this.serviceBaseUrl).name(this.name).id(this.id).compression(this.compression).projectId(this.projectId).typeFilter(this.typeFilter);
        }

        @NonNull
        public String getServiceBaseUrl() {
            return this.serviceBaseUrl;
        }

        @NonNull
        public String getName() {
            return this.name;
        }

        @NonNull
        public String getId() {
            return this.id;
        }

        public CompressionAlgorithm getCompression() {
            return this.compression;
        }

        public String getProjectId() {
            return this.projectId;
        }

        public String getTypeFilter() {
            return this.typeFilter;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Properties)) {
                return false;
            }
            Properties other = (Properties)o;
            String this$serviceBaseUrl = this.getServiceBaseUrl();
            String other$serviceBaseUrl = other.getServiceBaseUrl();
            if (this$serviceBaseUrl == null ? other$serviceBaseUrl != null : !this$serviceBaseUrl.equals(other$serviceBaseUrl)) {
                return false;
            }
            String this$name = this.getName();
            String other$name = other.getName();
            if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
                return false;
            }
            String this$id = this.getId();
            String other$id = other.getId();
            if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
                return false;
            }
            CompressionAlgorithm this$compression = this.getCompression();
            CompressionAlgorithm other$compression = other.getCompression();
            if (this$compression == null ? other$compression != null : !((Object)((Object)this$compression)).equals((Object)other$compression)) {
                return false;
            }
            String this$projectId = this.getProjectId();
            String other$projectId = other.getProjectId();
            if (this$projectId == null ? other$projectId != null : !this$projectId.equals(other$projectId)) {
                return false;
            }
            String this$typeFilter = this.getTypeFilter();
            String other$typeFilter = other.getTypeFilter();
            return !(this$typeFilter == null ? other$typeFilter != null : !this$typeFilter.equals(other$typeFilter));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $serviceBaseUrl = this.getServiceBaseUrl();
            result = result * 59 + ($serviceBaseUrl == null ? 43 : $serviceBaseUrl.hashCode());
            String $name = this.getName();
            result = result * 59 + ($name == null ? 43 : $name.hashCode());
            String $id = this.getId();
            result = result * 59 + ($id == null ? 43 : $id.hashCode());
            CompressionAlgorithm $compression = this.getCompression();
            result = result * 59 + ($compression == null ? 43 : ((Object)((Object)$compression)).hashCode());
            String $projectId = this.getProjectId();
            result = result * 59 + ($projectId == null ? 43 : $projectId.hashCode());
            String $typeFilter = this.getTypeFilter();
            result = result * 59 + ($typeFilter == null ? 43 : $typeFilter.hashCode());
            return result;
        }

        public String toString() {
            return "WebSocketClient.Properties(serviceBaseUrl=" + this.getServiceBaseUrl() + ", name=" + this.getName() + ", id=" + this.getId() + ", compression=" + (Object)((Object)this.getCompression()) + ", projectId=" + this.getProjectId() + ", typeFilter=" + this.getTypeFilter() + ")";
        }

        public static class PropertiesBuilder {
            private String serviceBaseUrl;
            private String name;
            private boolean id$set;
            private String id$value;
            private boolean compression$set;
            private CompressionAlgorithm compression$value;
            private String projectId;
            private String typeFilter;

            PropertiesBuilder() {
            }

            public PropertiesBuilder serviceBaseUrl(@NonNull String serviceBaseUrl) {
                if (serviceBaseUrl == null) {
                    throw new NullPointerException("serviceBaseUrl is marked non-null but is null");
                }
                this.serviceBaseUrl = serviceBaseUrl;
                return this;
            }

            public PropertiesBuilder name(@NonNull String name) {
                if (name == null) {
                    throw new NullPointerException("name is marked non-null but is null");
                }
                this.name = name;
                return this;
            }

            public PropertiesBuilder id(@NonNull String id) {
                if (id == null) {
                    throw new NullPointerException("id is marked non-null but is null");
                }
                this.id$value = id;
                this.id$set = true;
                return this;
            }

            public PropertiesBuilder compression(CompressionAlgorithm compression) {
                this.compression$value = compression;
                this.compression$set = true;
                return this;
            }

            public PropertiesBuilder projectId(String projectId) {
                this.projectId = projectId;
                return this;
            }

            public PropertiesBuilder typeFilter(String typeFilter) {
                this.typeFilter = typeFilter;
                return this;
            }

            public Properties build() {
                String id$value = this.id$value;
                if (!this.id$set) {
                    id$value = Properties.$default$id();
                }
                CompressionAlgorithm compression$value = this.compression$value;
                if (!this.compression$set) {
                    compression$value = Properties.$default$compression();
                }
                return new Properties(this.serviceBaseUrl, this.name, id$value, compression$value, this.projectId, this.typeFilter);
            }

            public String toString() {
                return "WebSocketClient.Properties.PropertiesBuilder(serviceBaseUrl=" + this.serviceBaseUrl + ", name=" + this.name + ", id$value=" + this.id$value + ", compression$value=" + (Object)((Object)this.compression$value) + ", projectId=" + this.projectId + ", typeFilter=" + this.typeFilter + ")";
            }
        }
    }
}

