/*
 * Decompiled with CFR 0.152.
 */
package io.fluxcapacitor.javaclient.eventsourcing;

import io.fluxcapacitor.common.MessageType;
import io.fluxcapacitor.common.api.Data;
import io.fluxcapacitor.common.api.SerializedMessage;
import io.fluxcapacitor.common.handling.Handler;
import io.fluxcapacitor.common.handling.ParameterResolver;
import io.fluxcapacitor.common.serialization.Revision;
import io.fluxcapacitor.javaclient.common.Message;
import io.fluxcapacitor.javaclient.common.caching.Cache;
import io.fluxcapacitor.javaclient.common.caching.NoCache;
import io.fluxcapacitor.javaclient.common.model.Model;
import io.fluxcapacitor.javaclient.common.serialization.DeserializingMessage;
import io.fluxcapacitor.javaclient.common.serialization.DeserializingObject;
import io.fluxcapacitor.javaclient.eventsourcing.Aggregate;
import io.fluxcapacitor.javaclient.eventsourcing.AnnotatedEventSourcingHandler;
import io.fluxcapacitor.javaclient.eventsourcing.EventSourced;
import io.fluxcapacitor.javaclient.eventsourcing.EventSourcing;
import io.fluxcapacitor.javaclient.eventsourcing.EventSourcingException;
import io.fluxcapacitor.javaclient.eventsourcing.EventSourcingHandler;
import io.fluxcapacitor.javaclient.eventsourcing.EventStore;
import io.fluxcapacitor.javaclient.eventsourcing.NoOpSnapshotRepository;
import io.fluxcapacitor.javaclient.eventsourcing.NoSnapshotTrigger;
import io.fluxcapacitor.javaclient.eventsourcing.PeriodicSnapshotTrigger;
import io.fluxcapacitor.javaclient.eventsourcing.SnapshotRepository;
import io.fluxcapacitor.javaclient.eventsourcing.SnapshotTrigger;
import io.fluxcapacitor.javaclient.tracking.handling.HandlerInterceptor;
import java.beans.ConstructorProperties;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultEventSourcing
implements EventSourcing,
HandlerInterceptor {
    private static final Logger log = LoggerFactory.getLogger(DefaultEventSourcing.class);
    private final Map<Class<?>, Function<LoadSettings, EventSourcedModel<?>>> modelFactories = new ConcurrentHashMap();
    private final EventStore eventStore;
    private final SnapshotRepository snapshotRepository;
    private final Cache cache;
    private final List<ParameterResolver<? super DeserializingMessage>> parameterResolvers;
    private final ThreadLocal<Collection<EventSourcedModel<?>>> loadedModels = new ThreadLocal();

    public DefaultEventSourcing(EventStore eventStore, SnapshotRepository snapshotRepository, Cache cache) {
        this(eventStore, snapshotRepository, cache, DeserializingMessage.defaultParameterResolvers);
    }

    @Override
    public <T> Model<T> load(String modelId, Class<T> modelType, boolean disableCaching, boolean disableSnapshotting) {
        Collection<EventSourcedModel<?>> loaded = this.loadedModels.get();
        if (loaded == null) {
            return this.createEsModel(modelType, modelId, disableCaching, disableSnapshotting);
        }
        return loaded.stream().filter(model -> ((EventSourcedModel)model).id.equals(modelId)).map(m -> m).findAny().orElseGet(() -> {
            EventSourcedModel model = this.createEsModel(modelType, modelId, disableCaching, disableSnapshotting);
            loaded.add(model);
            return model;
        });
    }

    @Override
    public void invalidateCache() {
        this.cache.invalidateAll();
    }

    @Override
    public EventStore eventStore() {
        return this.eventStore;
    }

    protected <T> EventSourcedModel<T> createEsModel(Class<T> modelType, String modelId, boolean disableCaching, boolean disableSnapshotting) {
        return (EventSourcedModel)this.modelFactories.computeIfAbsent(modelType, t -> {
            AnnotatedEventSourcingHandler eventSourcingHandler = new AnnotatedEventSourcingHandler(modelType, this.parameterResolvers);
            Cache cache = this.cache(modelType);
            SnapshotRepository snapshotRepository = this.snapshotRepository(modelType);
            SnapshotTrigger snapshotTrigger = this.snapshotTrigger(modelType);
            String domain = this.domain(modelType);
            return settings -> {
                EventSourcedModel eventSourcedModel = new EventSourcedModel(eventSourcingHandler, settings.disableCaching ? NoCache.INSTANCE : cache, this.eventStore, settings.disableSnapshotting ? NoOpSnapshotRepository.INSTANCE : snapshotRepository, snapshotTrigger, domain, this.loadedModels.get() == null, settings.modelId);
                eventSourcedModel.initialize();
                return eventSourcedModel;
            };
        }).apply(new LoadSettings(modelId, disableCaching, disableSnapshotting));
    }

    @Override
    public Function<DeserializingMessage, Object> interceptHandling(Function<DeserializingMessage, Object> function, Handler<DeserializingMessage> handler, String consumer) {
        return command -> {
            ArrayList models = new ArrayList();
            this.loadedModels.set(models);
            try {
                Object result = function.apply((DeserializingMessage)command);
                try {
                    while (!models.isEmpty()) {
                        ((EventSourcedModel)models.remove(models.size() - 1)).commit();
                    }
                }
                catch (Exception e) {
                    throw new EventSourcingException(String.format("Failed to commit applied events after handling %s", command), e);
                }
                Object r = result;
                return r;
            }
            finally {
                this.loadedModels.remove();
            }
        };
    }

    protected SnapshotRepository snapshotRepository(Class<?> modelType) {
        int frequency = Optional.ofNullable(modelType.getAnnotation(EventSourced.class)).map(EventSourced::snapshotPeriod).orElse((int)((Integer)EventSourced.class.getMethod("snapshotPeriod", new Class[0]).getDefaultValue()));
        return frequency > 0 ? this.snapshotRepository : NoOpSnapshotRepository.INSTANCE;
    }

    protected SnapshotTrigger snapshotTrigger(Class<?> modelType) {
        int frequency = Optional.ofNullable(modelType.getAnnotation(EventSourced.class)).map(EventSourced::snapshotPeriod).orElse((int)((Integer)EventSourced.class.getMethod("snapshotPeriod", new Class[0]).getDefaultValue()));
        return frequency > 0 ? new PeriodicSnapshotTrigger(frequency) : NoSnapshotTrigger.INSTANCE;
    }

    protected Cache cache(Class<?> modelType) {
        boolean cached = Optional.ofNullable(modelType.getAnnotation(EventSourced.class)).map(EventSourced::cached).orElse((boolean)((Boolean)EventSourced.class.getMethod("cached", new Class[0]).getDefaultValue()));
        return cached ? this.cache : NoCache.INSTANCE;
    }

    protected String domain(Class<?> modelType) {
        return Optional.ofNullable(modelType.getAnnotation(EventSourced.class)).map(EventSourced::domain).filter(s -> !s.isEmpty()).orElse(modelType.getSimpleName());
    }

    @ConstructorProperties(value={"eventStore", "snapshotRepository", "cache", "parameterResolvers"})
    public DefaultEventSourcing(EventStore eventStore, SnapshotRepository snapshotRepository, Cache cache, List<ParameterResolver<? super DeserializingMessage>> parameterResolvers) {
        this.eventStore = eventStore;
        this.snapshotRepository = snapshotRepository;
        this.cache = cache;
        this.parameterResolvers = parameterResolvers;
    }

    protected static class EventSourcedModel<T>
    implements Model<T> {
        private final EventSourcingHandler<T> eventSourcingHandler;
        private final Cache cache;
        private final EventStore eventStore;
        private final SnapshotRepository snapshotRepository;
        private final SnapshotTrigger snapshotTrigger;
        private final String domain;
        private final List<Message> unpublishedEvents = new ArrayList<Message>();
        private final boolean readOnly;
        private final String id;
        private Aggregate<T> aggregate;

        protected void initialize() {
            this.aggregate = Optional.ofNullable((Aggregate)this.cache.getIfPresent(this.id)).orElseGet(() -> {
                Aggregate<Object> aggregate = this.snapshotRepository.getSnapshot(this.id).orElse(new Aggregate<Object>(this.id, -1L, null));
                for (DeserializingMessage event : this.eventStore.getDomainEvents(this.id, aggregate.getSequenceNumber()).collect(Collectors.toList())) {
                    aggregate = aggregate.update(m -> this.eventSourcingHandler.apply(event, m));
                }
                return aggregate;
            });
        }

        @Override
        public Model<T> apply(Message message) {
            if (this.readOnly) {
                throw new EventSourcingException(String.format("Not allowed to apply a %s. The model is readonly.", message));
            }
            this.unpublishedEvents.add(message);
            DeserializingMessage deserializingMessage = new DeserializingMessage(new DeserializingObject<byte[], SerializedMessage>(new SerializedMessage(new Data(() -> {
                throw new UnsupportedOperationException("Serialized data not available");
            }, message.getPayload().getClass().getName(), Optional.ofNullable(message.getPayload().getClass().getAnnotation(Revision.class)).map(Revision::value).orElse(0).intValue()), message.getMetadata(), message.getMessageId(), Long.valueOf(message.getTimestamp().toEpochMilli())), message::getPayload), MessageType.EVENT);
            this.aggregate = this.aggregate.update(a -> this.eventSourcingHandler.apply(deserializingMessage, a));
            return this;
        }

        @Override
        public T get() {
            return this.aggregate.getModel();
        }

        @Override
        public long getSequenceNumber() {
            return this.aggregate.getSequenceNumber();
        }

        protected void commit() {
            if (!this.unpublishedEvents.isEmpty()) {
                this.cache.put(this.aggregate.getId(), this.aggregate);
                this.eventStore.storeDomainEvents(this.aggregate.getId(), this.domain, this.aggregate.getSequenceNumber(), new ArrayList<Message>(this.unpublishedEvents));
                if (this.snapshotTrigger.shouldCreateSnapshot(this.aggregate, this.unpublishedEvents)) {
                    this.snapshotRepository.storeSnapshot(this.aggregate);
                }
                this.unpublishedEvents.clear();
            }
        }

        @ConstructorProperties(value={"eventSourcingHandler", "cache", "eventStore", "snapshotRepository", "snapshotTrigger", "domain", "readOnly", "id"})
        public EventSourcedModel(EventSourcingHandler<T> eventSourcingHandler, Cache cache, EventStore eventStore, SnapshotRepository snapshotRepository, SnapshotTrigger snapshotTrigger, String domain, boolean readOnly, String id) {
            this.eventSourcingHandler = eventSourcingHandler;
            this.cache = cache;
            this.eventStore = eventStore;
            this.snapshotRepository = snapshotRepository;
            this.snapshotTrigger = snapshotTrigger;
            this.domain = domain;
            this.readOnly = readOnly;
            this.id = id;
        }
    }

    protected static class LoadSettings {
        String modelId;
        boolean disableCaching;
        boolean disableSnapshotting;

        @ConstructorProperties(value={"modelId", "disableCaching", "disableSnapshotting"})
        public LoadSettings(String modelId, boolean disableCaching, boolean disableSnapshotting) {
            this.modelId = modelId;
            this.disableCaching = disableCaching;
            this.disableSnapshotting = disableSnapshotting;
        }
    }
}

