/*
 * Decompiled with CFR 0.152.
 */
package io.fluxcapacitor.javaclient.eventsourcing;

import io.fluxcapacitor.common.ConsistentHashing;
import io.fluxcapacitor.common.MessageType;
import io.fluxcapacitor.common.Registration;
import io.fluxcapacitor.common.api.SerializedMessage;
import io.fluxcapacitor.common.handling.Handler;
import io.fluxcapacitor.javaclient.common.Message;
import io.fluxcapacitor.javaclient.common.serialization.DeserializingMessage;
import io.fluxcapacitor.javaclient.common.serialization.DeserializingObject;
import io.fluxcapacitor.javaclient.eventsourcing.EventSourcingException;
import io.fluxcapacitor.javaclient.eventsourcing.EventStore;
import io.fluxcapacitor.javaclient.eventsourcing.EventStoreSerializer;
import io.fluxcapacitor.javaclient.eventsourcing.client.EventStoreClient;
import io.fluxcapacitor.javaclient.tracking.handling.HandlerFactory;
import java.beans.ConstructorProperties;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.stream.Stream;

public class DefaultEventStore
implements EventStore {
    private final EventStoreClient client;
    private final EventStoreSerializer serializer;
    private final HandlerFactory handlerFactory;
    private final List<Handler<DeserializingMessage>> localHandlers = new CopyOnWriteArrayList<Handler<DeserializingMessage>>();

    @Override
    public void storeDomainEvents(String aggregateId, String domain, long lastSequenceNumber, List<Message> events) {
        try {
            int segment = ConsistentHashing.computeSegment((String)aggregateId);
            ArrayList<SerializedMessage> messages = new ArrayList<SerializedMessage>(events.size());
            events.forEach(e -> {
                SerializedMessage message = this.serializer.serialize((Message)e).withSegment(Integer.valueOf(segment));
                messages.add(message);
                this.tryHandleLocally(e.getPayload(), message);
            });
            this.client.storeEvents(aggregateId, domain, lastSequenceNumber, messages).await();
        }
        catch (Exception e2) {
            throw new EventSourcingException(String.format("Failed to store events %s for aggregate %s", events, aggregateId), e2);
        }
    }

    @Override
    public Stream<DeserializingMessage> getDomainEvents(String aggregateId, long lastSequenceNumber) {
        try {
            return this.serializer.deserializeDomainEvents(this.client.getEvents(aggregateId, lastSequenceNumber));
        }
        catch (Exception e) {
            throw new EventSourcingException(String.format("Failed to obtain domain events for aggregate %s", aggregateId), e);
        }
    }

    @Override
    public Registration registerLocalHandler(Object target) {
        Optional<Handler<DeserializingMessage>> handler = this.handlerFactory.createHandler(target);
        handler.ifPresent(this.localHandlers::add);
        return () -> handler.ifPresent(this.localHandlers::remove);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void tryHandleLocally(Object payload, SerializedMessage serializedMessage) {
        if (!this.localHandlers.isEmpty()) {
            DeserializingMessage current = DeserializingMessage.getCurrent();
            try {
                DeserializingMessage deserializingMessage = new DeserializingMessage(new DeserializingObject<byte[], SerializedMessage>(serializedMessage, () -> payload), MessageType.EVENT);
                DeserializingMessage.setCurrent(deserializingMessage);
                for (Handler<DeserializingMessage> handler : this.localHandlers) {
                    try {
                        if (!handler.canHandle((Object)deserializingMessage)) continue;
                        handler.invoke((Object)deserializingMessage);
                    }
                    finally {
                        handler.onEndOfBatch();
                    }
                }
            }
            finally {
                DeserializingMessage.setCurrent(current);
            }
        }
    }

    @ConstructorProperties(value={"client", "serializer", "handlerFactory"})
    public DefaultEventStore(EventStoreClient client, EventStoreSerializer serializer, HandlerFactory handlerFactory) {
        this.client = client;
        this.serializer = serializer;
        this.handlerFactory = handlerFactory;
    }
}

