/*
 * Decompiled with CFR 0.152.
 */
package io.fluxcapacitor.javaclient.eventsourcing.client;

import io.fluxcapacitor.common.Awaitable;
import io.fluxcapacitor.common.Backlog;
import io.fluxcapacitor.common.ObjectUtils;
import io.fluxcapacitor.common.api.Request;
import io.fluxcapacitor.common.api.SerializedMessage;
import io.fluxcapacitor.common.api.eventsourcing.AppendEvents;
import io.fluxcapacitor.common.api.eventsourcing.EventBatch;
import io.fluxcapacitor.common.api.eventsourcing.GetEvents;
import io.fluxcapacitor.common.api.eventsourcing.GetEventsResult;
import io.fluxcapacitor.javaclient.common.websocket.AbstractWebsocketClient;
import io.fluxcapacitor.javaclient.configuration.client.WebSocketClient;
import io.fluxcapacitor.javaclient.eventsourcing.client.EventStoreClient;
import java.net.URI;
import java.util.List;
import java.util.stream.Stream;
import javax.websocket.ClientEndpoint;

@ClientEndpoint
public class WebSocketEventStoreClient
extends AbstractWebsocketClient
implements EventStoreClient {
    private final Backlog<EventBatch> backlog;
    private final int fetchBatchSize;

    public WebSocketEventStoreClient(String endPointUrl, WebSocketClient.Properties properties) {
        this(URI.create(endPointUrl), 1024, 8192, properties);
    }

    public WebSocketEventStoreClient(String endPointUrl, int backlogSize, WebSocketClient.Properties properties) {
        this(URI.create(endPointUrl), backlogSize, 1024, properties);
    }

    public WebSocketEventStoreClient(URI endPointUri, int backlogSize, int fetchBatchSize, WebSocketClient.Properties properties) {
        super(endPointUri, properties);
        this.backlog = new Backlog(this::doSend, backlogSize);
        this.fetchBatchSize = fetchBatchSize;
    }

    @Override
    public Awaitable storeEvents(String aggregateId, String domain, long lastSequenceNumber, List<SerializedMessage> events) {
        return this.backlog.add((Object[])new EventBatch[]{new EventBatch(aggregateId, domain, lastSequenceNumber, events)});
    }

    private Awaitable doSend(List<EventBatch> batches) {
        this.sendRequestAndWait((Request)new AppendEvents(batches));
        return Awaitable.ready();
    }

    @Override
    public Stream<SerializedMessage> getEvents(String aggregateId, long lastSequenceNumber) {
        return ObjectUtils.iterate((Object)((GetEventsResult)this.sendRequestAndWait((Request)new GetEvents(aggregateId, Long.valueOf(lastSequenceNumber), this.fetchBatchSize))), r -> (GetEventsResult)this.sendRequestAndWait((Request)new GetEvents(aggregateId, Long.valueOf(r.getEventBatch().getLastSequenceNumber()), this.fetchBatchSize)), r -> r.getEventBatch().getEvents().size() < this.fetchBatchSize).flatMap(r -> r.getEventBatch().getEvents().stream());
    }
}

