/*
 * Decompiled with CFR 0.152.
 */
package io.fluxcapacitor.javaclient.scheduling;

import io.fluxcapacitor.common.api.Metadata;
import io.fluxcapacitor.common.api.scheduling.ScheduledMessage;
import io.fluxcapacitor.javaclient.common.Message;
import io.fluxcapacitor.javaclient.common.serialization.MessageSerializer;
import io.fluxcapacitor.javaclient.scheduling.Scheduler;
import io.fluxcapacitor.javaclient.scheduling.SchedulerException;
import io.fluxcapacitor.javaclient.scheduling.client.SchedulingClient;
import java.beans.ConstructorProperties;
import java.time.Instant;

public class DefaultScheduler
implements Scheduler {
    private final SchedulingClient client;
    private final MessageSerializer serializer;

    @Override
    public void schedule(String scheduleId, Instant timestamp, Object payload, Metadata metadata) {
        try {
            this.client.schedule(new ScheduledMessage(scheduleId, timestamp.toEpochMilli(), this.serializer.serialize(new Message(payload, metadata)))).await();
        }
        catch (Exception e) {
            throw new SchedulerException(String.format("Failed to schedule message %s for %s", payload, timestamp), e);
        }
    }

    @Override
    public void cancelSchedule(String scheduleId) {
        try {
            this.client.cancelSchedule(scheduleId).await();
        }
        catch (Exception e) {
            throw new SchedulerException(String.format("Failed to cancel schedule with id %s", scheduleId), e);
        }
    }

    @ConstructorProperties(value={"client", "serializer"})
    public DefaultScheduler(SchedulingClient client, MessageSerializer serializer) {
        this.client = client;
        this.serializer = serializer;
    }
}

