/*
 * Decompiled with CFR 0.152.
 */
package io.fluxcapacitor.javaclient.tracking;

import io.fluxcapacitor.common.MessageType;
import io.fluxcapacitor.javaclient.tracking.ErrorHandler;
import io.fluxcapacitor.javaclient.tracking.LoggingErrorHandler;
import io.fluxcapacitor.javaclient.tracking.TrackingConfiguration;
import java.beans.ConstructorProperties;
import java.util.function.Function;
import java.util.function.Predicate;
import lombok.NonNull;

public final class ConsumerConfiguration {
    public static Function<MessageType, String> DEFAULT_CONSUMER_NAME = Enum::name;
    @NonNull
    private final MessageType messageType;
    @NonNull
    private final String name;
    private final boolean prependApplicationName;
    @NonNull
    private final Predicate<Object> handlerFilter;
    @NonNull
    private final TrackingConfiguration trackingConfiguration;
    @NonNull
    private final ErrorHandler errorHandler;

    public static ConsumerConfiguration getDefault(MessageType messageType) {
        return ConsumerConfiguration.builder().messageType(messageType).name(DEFAULT_CONSUMER_NAME.apply(messageType)).build();
    }

    private static boolean $default$prependApplicationName() {
        return true;
    }

    private static Predicate<Object> $default$handlerFilter() {
        return o -> true;
    }

    private static TrackingConfiguration $default$trackingConfiguration() {
        return TrackingConfiguration.DEFAULT;
    }

    private static ErrorHandler $default$errorHandler() {
        return new LoggingErrorHandler();
    }

    @ConstructorProperties(value={"messageType", "name", "prependApplicationName", "handlerFilter", "trackingConfiguration", "errorHandler"})
    ConsumerConfiguration(@NonNull MessageType messageType, @NonNull String name, boolean prependApplicationName, @NonNull Predicate<Object> handlerFilter, @NonNull TrackingConfiguration trackingConfiguration, @NonNull ErrorHandler errorHandler) {
        if (messageType == null) {
            throw new NullPointerException("messageType is marked non-null but is null");
        }
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        if (handlerFilter == null) {
            throw new NullPointerException("handlerFilter is marked non-null but is null");
        }
        if (trackingConfiguration == null) {
            throw new NullPointerException("trackingConfiguration is marked non-null but is null");
        }
        if (errorHandler == null) {
            throw new NullPointerException("errorHandler is marked non-null but is null");
        }
        this.messageType = messageType;
        this.name = name;
        this.prependApplicationName = prependApplicationName;
        this.handlerFilter = handlerFilter;
        this.trackingConfiguration = trackingConfiguration;
        this.errorHandler = errorHandler;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().messageType(this.messageType).name(this.name).prependApplicationName(this.prependApplicationName).handlerFilter(this.handlerFilter).trackingConfiguration(this.trackingConfiguration).errorHandler(this.errorHandler);
    }

    @NonNull
    public MessageType getMessageType() {
        return this.messageType;
    }

    @NonNull
    public String getName() {
        return this.name;
    }

    public boolean prependApplicationName() {
        return this.prependApplicationName;
    }

    @NonNull
    public Predicate<Object> getHandlerFilter() {
        return this.handlerFilter;
    }

    @NonNull
    public TrackingConfiguration getTrackingConfiguration() {
        return this.trackingConfiguration;
    }

    @NonNull
    public ErrorHandler getErrorHandler() {
        return this.errorHandler;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ConsumerConfiguration)) {
            return false;
        }
        ConsumerConfiguration other = (ConsumerConfiguration)o;
        MessageType this$messageType = this.getMessageType();
        MessageType other$messageType = other.getMessageType();
        if (this$messageType == null ? other$messageType != null : !this$messageType.equals(other$messageType)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        if (this.prependApplicationName() != other.prependApplicationName()) {
            return false;
        }
        Predicate<Object> this$handlerFilter = this.getHandlerFilter();
        Predicate<Object> other$handlerFilter = other.getHandlerFilter();
        if (this$handlerFilter == null ? other$handlerFilter != null : !this$handlerFilter.equals(other$handlerFilter)) {
            return false;
        }
        TrackingConfiguration this$trackingConfiguration = this.getTrackingConfiguration();
        TrackingConfiguration other$trackingConfiguration = other.getTrackingConfiguration();
        if (this$trackingConfiguration == null ? other$trackingConfiguration != null : !((Object)this$trackingConfiguration).equals(other$trackingConfiguration)) {
            return false;
        }
        ErrorHandler this$errorHandler = this.getErrorHandler();
        ErrorHandler other$errorHandler = other.getErrorHandler();
        return !(this$errorHandler == null ? other$errorHandler != null : !this$errorHandler.equals(other$errorHandler));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        MessageType $messageType = this.getMessageType();
        result = result * 59 + ($messageType == null ? 43 : $messageType.hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        result = result * 59 + (this.prependApplicationName() ? 79 : 97);
        Predicate<Object> $handlerFilter = this.getHandlerFilter();
        result = result * 59 + ($handlerFilter == null ? 43 : $handlerFilter.hashCode());
        TrackingConfiguration $trackingConfiguration = this.getTrackingConfiguration();
        result = result * 59 + ($trackingConfiguration == null ? 43 : ((Object)$trackingConfiguration).hashCode());
        ErrorHandler $errorHandler = this.getErrorHandler();
        result = result * 59 + ($errorHandler == null ? 43 : $errorHandler.hashCode());
        return result;
    }

    public String toString() {
        return "ConsumerConfiguration(messageType=" + this.getMessageType() + ", name=" + this.getName() + ", prependApplicationName=" + this.prependApplicationName() + ", handlerFilter=" + this.getHandlerFilter() + ", trackingConfiguration=" + this.getTrackingConfiguration() + ", errorHandler=" + this.getErrorHandler() + ")";
    }

    public static class Builder {
        private MessageType messageType;
        private String name;
        private boolean prependApplicationName$set;
        private boolean prependApplicationName$value;
        private boolean handlerFilter$set;
        private Predicate<Object> handlerFilter$value;
        private boolean trackingConfiguration$set;
        private TrackingConfiguration trackingConfiguration$value;
        private boolean errorHandler$set;
        private ErrorHandler errorHandler$value;

        Builder() {
        }

        public Builder messageType(@NonNull MessageType messageType) {
            if (messageType == null) {
                throw new NullPointerException("messageType is marked non-null but is null");
            }
            this.messageType = messageType;
            return this;
        }

        public Builder name(@NonNull String name) {
            if (name == null) {
                throw new NullPointerException("name is marked non-null but is null");
            }
            this.name = name;
            return this;
        }

        public Builder prependApplicationName(boolean prependApplicationName) {
            this.prependApplicationName$value = prependApplicationName;
            this.prependApplicationName$set = true;
            return this;
        }

        public Builder handlerFilter(@NonNull Predicate<Object> handlerFilter) {
            if (handlerFilter == null) {
                throw new NullPointerException("handlerFilter is marked non-null but is null");
            }
            this.handlerFilter$value = handlerFilter;
            this.handlerFilter$set = true;
            return this;
        }

        public Builder trackingConfiguration(@NonNull TrackingConfiguration trackingConfiguration) {
            if (trackingConfiguration == null) {
                throw new NullPointerException("trackingConfiguration is marked non-null but is null");
            }
            this.trackingConfiguration$value = trackingConfiguration;
            this.trackingConfiguration$set = true;
            return this;
        }

        public Builder errorHandler(@NonNull ErrorHandler errorHandler) {
            if (errorHandler == null) {
                throw new NullPointerException("errorHandler is marked non-null but is null");
            }
            this.errorHandler$value = errorHandler;
            this.errorHandler$set = true;
            return this;
        }

        public ConsumerConfiguration build() {
            boolean prependApplicationName$value = this.prependApplicationName$value;
            if (!this.prependApplicationName$set) {
                prependApplicationName$value = ConsumerConfiguration.$default$prependApplicationName();
            }
            Predicate handlerFilter$value = this.handlerFilter$value;
            if (!this.handlerFilter$set) {
                handlerFilter$value = ConsumerConfiguration.$default$handlerFilter();
            }
            TrackingConfiguration trackingConfiguration$value = this.trackingConfiguration$value;
            if (!this.trackingConfiguration$set) {
                trackingConfiguration$value = ConsumerConfiguration.$default$trackingConfiguration();
            }
            ErrorHandler errorHandler$value = this.errorHandler$value;
            if (!this.errorHandler$set) {
                errorHandler$value = ConsumerConfiguration.$default$errorHandler();
            }
            return new ConsumerConfiguration(this.messageType, this.name, prependApplicationName$value, handlerFilter$value, trackingConfiguration$value, errorHandler$value);
        }

        public String toString() {
            return "ConsumerConfiguration.Builder(messageType=" + this.messageType + ", name=" + this.name + ", prependApplicationName$value=" + this.prependApplicationName$value + ", handlerFilter$value=" + this.handlerFilter$value + ", trackingConfiguration$value=" + this.trackingConfiguration$value + ", errorHandler$value=" + this.errorHandler$value + ")";
        }
    }
}

