/*
 * Decompiled with CFR 0.152.
 */
package io.fluxcapacitor.javaclient.tracking;

import io.fluxcapacitor.common.MessageType;
import io.fluxcapacitor.common.Registration;
import io.fluxcapacitor.common.api.SerializedMessage;
import io.fluxcapacitor.common.handling.Handler;
import io.fluxcapacitor.common.handling.HandlerConfiguration;
import io.fluxcapacitor.common.handling.HandlerInspector;
import io.fluxcapacitor.common.handling.ParameterResolver;
import io.fluxcapacitor.javaclient.FluxCapacitor;
import io.fluxcapacitor.javaclient.common.ClientUtils;
import io.fluxcapacitor.javaclient.common.exception.FunctionalException;
import io.fluxcapacitor.javaclient.common.exception.TechnicalException;
import io.fluxcapacitor.javaclient.common.serialization.DeserializingMessage;
import io.fluxcapacitor.javaclient.common.serialization.DeserializingObject;
import io.fluxcapacitor.javaclient.common.serialization.Serializer;
import io.fluxcapacitor.javaclient.eventsourcing.CacheInvalidatingInterceptor;
import io.fluxcapacitor.javaclient.publishing.ResultGateway;
import io.fluxcapacitor.javaclient.tracking.ConsumerConfiguration;
import io.fluxcapacitor.javaclient.tracking.FluxCapacitorInterceptor;
import io.fluxcapacitor.javaclient.tracking.Tracking;
import io.fluxcapacitor.javaclient.tracking.TrackingConfiguration;
import io.fluxcapacitor.javaclient.tracking.TrackingException;
import io.fluxcapacitor.javaclient.tracking.client.TrackingClient;
import io.fluxcapacitor.javaclient.tracking.client.TrackingUtils;
import io.fluxcapacitor.javaclient.tracking.handling.HandlerInterceptor;
import java.beans.ConstructorProperties;
import java.lang.annotation.Annotation;
import java.lang.reflect.Executable;
import java.lang.reflect.Method;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultTracking
implements Tracking {
    private static final Logger log = LoggerFactory.getLogger(DefaultTracking.class);
    private final Object $lock = new Object[0];
    private final MessageType messageType;
    private final Class<? extends Annotation> handlerAnnotation;
    private final TrackingClient trackingClient;
    private final ResultGateway resultGateway;
    private final List<ConsumerConfiguration> configurations;
    private final Serializer serializer;
    private final HandlerInterceptor handlerInterceptor;
    private final List<ParameterResolver<? super DeserializingMessage>> parameterResolvers;
    private final Set<ConsumerConfiguration> startedConfigurations = new HashSet<ConsumerConfiguration>();
    private final Collection<CompletableFuture<?>> outstandingRequests = new CopyOnWriteArrayList();
    private final AtomicReference<Registration> shutdownFunction = new AtomicReference<Registration>(Registration.noOp());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Registration start(FluxCapacitor fluxCapacitor, List<?> handlers) {
        Object object = this.$lock;
        synchronized (object) {
            Map<ConsumerConfiguration, List<Object>> consumers = handlers.stream().filter(h -> HandlerInspector.hasHandlerMethods(h.getClass(), this.handlerAnnotation)).collect(Collectors.groupingBy(h -> this.configurations.stream().filter(config -> config.getHandlerFilter().test(h)).findFirst().orElseThrow(() -> new TrackingException(String.format("Failed to find consumer for %s", h)))));
            if (!Collections.disjoint(consumers.keySet(), this.startedConfigurations)) {
                throw new TrackingException("Failed to start tracking. Consumers for some handlers have already started tracking.");
            }
            this.startedConfigurations.addAll(consumers.keySet());
            Registration registration = consumers.entrySet().stream().map(e -> this.startTracking((ConsumerConfiguration)e.getKey(), (List)e.getValue(), fluxCapacitor)).reduce(Registration::merge).orElse(Registration.noOp());
            registration = registration.merge(() -> ClientUtils.waitForResults(Duration.ofSeconds(2L), this.outstandingRequests));
            this.shutdownFunction.set(registration);
            return registration;
        }
    }

    protected Registration startTracking(ConsumerConfiguration configuration, List<Object> handlers, FluxCapacitor fluxCapacitor) {
        Consumer<List<SerializedMessage>> consumer = this.createConsumer(configuration, handlers);
        ArrayList<FluxCapacitorInterceptor> batchInterceptors = new ArrayList<FluxCapacitorInterceptor>(Collections.singletonList(new FluxCapacitorInterceptor(fluxCapacitor)));
        if (configuration.getMessageType() == MessageType.COMMAND) {
            batchInterceptors.add((FluxCapacitorInterceptor)((Object)new CacheInvalidatingInterceptor(fluxCapacitor.eventSourcing())));
        }
        batchInterceptors.addAll(configuration.getTrackingConfiguration().getBatchInterceptors());
        Supplier<String> trackerIdFactory = configuration.getTrackingConfiguration().getTrackerIdFactory();
        TrackingConfiguration config = configuration.getTrackingConfiguration().toBuilder().clearBatchInterceptors().batchInterceptors(batchInterceptors).trackerIdFactory(() -> String.format("%s_%s", fluxCapacitor.client().id(), trackerIdFactory.get())).build();
        String trackerName = configuration.prependApplicationName() ? String.format("%s_%s", fluxCapacitor.client().name(), configuration.getName()) : configuration.getName();
        return TrackingUtils.start(trackerName, consumer, this.trackingClient, config);
    }

    protected Consumer<List<SerializedMessage>> createConsumer(ConsumerConfiguration configuration, List<Object> targets) {
        List handlers = targets.stream().filter(o -> HandlerInspector.hasHandlerMethods(o.getClass(), this.handlerAnnotation)).map(o -> HandlerInspector.createHandler((Object)o, this.handlerAnnotation, this.parameterResolvers, (HandlerConfiguration)HandlerConfiguration.builder().invokerFactory(DeserializingMessage.defaultInvokerFactory).build())).collect(Collectors.toList());
        return serializedMessages -> {
            Iterator iterator = this.serializer.deserialize(serializedMessages.stream(), false).map(m -> new DeserializingMessage((DeserializingObject<byte[], SerializedMessage>)m, this.messageType)).iterator();
            iterator.forEachRemaining(m -> {
                try {
                    DeserializingMessage.setCurrent(m);
                    handlers.forEach(h -> this.tryHandle((DeserializingMessage)m, (Handler<DeserializingMessage>)h, configuration));
                    if (!iterator.hasNext()) {
                        handlers.forEach(Handler::onEndOfBatch);
                    }
                }
                finally {
                    DeserializingMessage.removeCurrent();
                }
            });
        };
    }

    protected void tryHandle(DeserializingMessage message, Handler<DeserializingMessage> handler, ConsumerConfiguration config) {
        try {
            if (handler.canHandle((Object)message)) {
                this.handle(message, handler, config);
            }
        }
        catch (Exception e) {
            config.getErrorHandler().handleError(e, String.format("Handler %s failed to handle a %s", handler, message), () -> this.handle(message, handler, config));
        }
    }

    protected void handle(DeserializingMessage message, Handler<DeserializingMessage> handler, ConsumerConfiguration config) {
        Object result;
        Exception exception = null;
        try {
            result = this.handlerInterceptor.interceptHandling(m -> handler.invoke((Object)message), handler, config.getName()).apply(message);
        }
        catch (FunctionalException e2) {
            result = e2;
            exception = e2;
        }
        catch (Exception e3) {
            result = new TechnicalException(String.format("Handler %s failed to handle a %s", handler, message));
            exception = e3;
        }
        SerializedMessage serializedMessage = message.getSerializedObject();
        boolean shouldSendResponse = this.shouldSendResponse(handler, message);
        if (result instanceof CompletableFuture) {
            CompletionStage future = ((CompletableFuture)result).whenComplete((r, e) -> {
                Object asyncResult = r;
                if (e != null && !(e instanceof FunctionalException)) {
                    asyncResult = new TechnicalException(String.format("Handler %s failed to handle a %s", handler, message));
                }
                try {
                    DeserializingMessage.setCurrent(message);
                    if (shouldSendResponse) {
                        this.resultGateway.respond(asyncResult, serializedMessage.getSource(), serializedMessage.getRequestId());
                    }
                    if (e != null) {
                        config.getErrorHandler().handleError((Exception)e, String.format("Handler %s failed to handle a %s", handler, message), () -> this.handle(message, handler, config));
                    }
                }
                catch (Exception exc) {
                    log.warn("Did not stop consumer {} after async handler {} failed to handle a {}", new Object[]{config.getName(), handler, message, exc});
                }
                finally {
                    DeserializingMessage.removeCurrent();
                }
            });
            this.outstandingRequests.add((CompletableFuture<?>)future);
            ((CompletableFuture)future).whenComplete((arg_0, arg_1) -> this.lambda$handle$17((CompletableFuture)future, arg_0, arg_1));
        } else if (shouldSendResponse) {
            this.resultGateway.respond(result, serializedMessage.getSource(), serializedMessage.getRequestId());
        }
        if (exception != null) {
            throw exception;
        }
    }

    private boolean shouldSendResponse(Handler<DeserializingMessage> handler, DeserializingMessage message) {
        SerializedMessage serializedMessage = message.getSerializedObject();
        if (serializedMessage.getRequestId() == null) {
            return false;
        }
        Executable method = handler.getMethod((Object)message);
        Annotation annotation = method.getAnnotation(this.handlerAnnotation);
        Optional<Method> isPassive = Arrays.stream(this.handlerAnnotation.getMethods()).filter(m -> m.getName().equals("passive")).findFirst();
        if (isPassive.isPresent()) {
            return (Boolean)isPassive.get().invoke((Object)annotation, new Object[0]) == false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        Object object = this.$lock;
        synchronized (object) {
            this.shutdownFunction.get().cancel();
        }
    }

    @ConstructorProperties(value={"messageType", "handlerAnnotation", "trackingClient", "resultGateway", "configurations", "serializer", "handlerInterceptor", "parameterResolvers"})
    public DefaultTracking(MessageType messageType, Class<? extends Annotation> handlerAnnotation, TrackingClient trackingClient, ResultGateway resultGateway, List<ConsumerConfiguration> configurations, Serializer serializer, HandlerInterceptor handlerInterceptor, List<ParameterResolver<? super DeserializingMessage>> parameterResolvers) {
        this.messageType = messageType;
        this.handlerAnnotation = handlerAnnotation;
        this.trackingClient = trackingClient;
        this.resultGateway = resultGateway;
        this.configurations = configurations;
        this.serializer = serializer;
        this.handlerInterceptor = handlerInterceptor;
        this.parameterResolvers = parameterResolvers;
    }

    private /* synthetic */ void lambda$handle$17(CompletableFuture future, Object r, Throwable e) {
        this.outstandingRequests.remove(future);
    }
}

