/*
 * Decompiled with CFR 0.152.
 */
package io.fluxcapacitor.javaclient.tracking.handling;

import io.fluxcapacitor.common.api.SerializedMessage;
import io.fluxcapacitor.common.handling.HandlerInspector;
import io.fluxcapacitor.common.handling.ParameterResolver;
import io.fluxcapacitor.javaclient.common.serialization.DeserializingMessage;
import io.fluxcapacitor.javaclient.common.serialization.DeserializingObject;
import java.lang.reflect.Executable;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.WildcardType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public class BatchHandlerInvoker
extends HandlerInspector.MethodHandlerInvoker<DeserializingMessage> {
    private final Class<?> elementType;
    private final Map<Object, LinkedHashMap<DeserializingMessage, CompletableFuture<Object>>> batches = new ConcurrentHashMap<Object, LinkedHashMap<DeserializingMessage, CompletableFuture<Object>>>();

    public static boolean handlesBatch(Executable method) {
        return method.getParameterCount() > 0 && List.class.isAssignableFrom(method.getParameters()[0].getType());
    }

    public BatchHandlerInvoker(Executable executable, Class<?> enclosingType, List<ParameterResolver<? super DeserializingMessage>> parameterResolvers) {
        super(executable, enclosingType, parameterResolvers);
        if (!BatchHandlerInvoker.handlesBatch(executable)) {
            throw new IllegalArgumentException(String.format("Delegate does not handle Collection types: %s", executable));
        }
        this.elementType = BatchHandlerInvoker.getListElementType(executable);
    }

    public Object invoke(Object target, DeserializingMessage message) {
        CompletableFuture result = new CompletableFuture();
        Map batch = this.batches.computeIfAbsent(target, t -> new LinkedHashMap());
        batch.put(message, result);
        return result;
    }

    public void onEndOfBatch() {
        try {
            this.batches.forEach((target, batch) -> {
                ArrayList futures = new ArrayList(batch.values());
                try {
                    DeserializingMessage message = (DeserializingMessage)batch.keySet().stream().findFirst().orElseThrow(() -> new IllegalStateException("expected at least one value"));
                    List payloads = new ArrayList(batch.keySet()).stream().map(DeserializingMessage::getPayload).collect(Collectors.toList());
                    DeserializingMessage merged = new DeserializingMessage(new DeserializingObject<byte[], SerializedMessage>(message.getSerializedObject(), () -> payloads), message.getMessageType());
                    Object listResult = super.invoke(target, (Object)merged);
                    if (listResult instanceof Collection) {
                        ArrayList results = new ArrayList((Collection)listResult);
                        if (results.size() != futures.size()) {
                            throw new IllegalStateException(String.format("Number of results from method (%s) does not match number of handled messages (%s)", results.size(), futures.size()));
                        }
                        for (int i = 0; i < results.size(); ++i) {
                            Object r = results.get(i);
                            CompletableFuture future = (CompletableFuture)futures.get(i);
                            if (r instanceof CompletionStage) {
                                ((CompletionStage)r).whenComplete((o, e) -> {
                                    if (e == null) {
                                        future.complete(o);
                                    } else {
                                        future.completeExceptionally((Throwable)e);
                                    }
                                });
                                continue;
                            }
                            future.complete(r);
                        }
                    } else {
                        futures.forEach(f -> f.complete(listResult));
                    }
                }
                catch (Exception e2) {
                    futures.forEach(f -> f.completeExceptionally(e2));
                }
            });
        }
        finally {
            this.batches.clear();
        }
    }

    protected Class<?> getPayloadType() {
        return this.elementType;
    }

    protected Predicate<DeserializingMessage> getMatcher(Executable executable, List<ParameterResolver<? super DeserializingMessage>> parameterResolvers) {
        Class<?> elementType = BatchHandlerInvoker.getListElementType(executable);
        return d -> elementType.isAssignableFrom(d.getPayloadClass());
    }

    private static Class<?> getListElementType(Executable method) {
        Type type = method.getGenericParameterTypes()[0];
        if (type instanceof ParameterizedType) {
            Type elementType = ((ParameterizedType)type).getActualTypeArguments()[0];
            if (elementType instanceof WildcardType) {
                Type[] upperBounds = ((WildcardType)elementType).getUpperBounds();
                elementType = upperBounds.length > 0 ? upperBounds[0] : null;
            }
            return elementType instanceof Class ? (Class)elementType : Object.class;
        }
        return Object.class;
    }
}

