/*
 * Decompiled with CFR 0.152.
 */
package io.fluxcapacitor.javaclient.tracking.handling.errorreporting;

import io.fluxcapacitor.common.handling.Handler;
import io.fluxcapacitor.javaclient.common.Message;
import io.fluxcapacitor.javaclient.common.exception.FunctionalException;
import io.fluxcapacitor.javaclient.common.exception.TechnicalException;
import io.fluxcapacitor.javaclient.common.serialization.DeserializingMessage;
import io.fluxcapacitor.javaclient.publishing.ErrorGateway;
import io.fluxcapacitor.javaclient.tracking.handling.HandlerInterceptor;
import java.beans.ConstructorProperties;
import java.util.concurrent.CompletionStage;
import java.util.function.Function;

public class ErrorReportingInterceptor
implements HandlerInterceptor {
    private final ErrorGateway errorGateway;

    @Override
    public Function<DeserializingMessage, Object> interceptHandling(Function<DeserializingMessage, Object> function, Handler<DeserializingMessage> handler, String consumer) {
        return m -> {
            try {
                Object result = function.apply((DeserializingMessage)m);
                if (result instanceof CompletionStage) {
                    ((CompletionStage)result).whenComplete((r, e) -> {
                        if (e != null) {
                            DeserializingMessage current = DeserializingMessage.getCurrent();
                            try {
                                DeserializingMessage.setCurrent(m);
                                this.reportError((Throwable)e, handler, (DeserializingMessage)m);
                            }
                            finally {
                                DeserializingMessage.setCurrent(current);
                            }
                        }
                    });
                }
                return result;
            }
            catch (Exception e2) {
                this.reportError(e2, handler, (DeserializingMessage)m);
                throw e2;
            }
        };
    }

    protected void reportError(Throwable e, Handler<DeserializingMessage> handler, DeserializingMessage cause) {
        if (!(e instanceof FunctionalException) && !(e instanceof TechnicalException)) {
            e = new TechnicalException(String.format("Handler %s failed to handle a %s", handler, cause));
        }
        this.errorGateway.report(new Message(e, cause.getMetadata()), cause.getSerializedObject().getSource());
    }

    @ConstructorProperties(value={"errorGateway"})
    public ErrorReportingInterceptor(ErrorGateway errorGateway) {
        this.errorGateway = errorGateway;
    }
}

