/*
 * Decompiled with CFR 0.152.
 */
package io.fluxcapacitor.javaclient.tracking.metrics;

import io.fluxcapacitor.common.handling.Handler;
import io.fluxcapacitor.javaclient.FluxCapacitor;
import io.fluxcapacitor.javaclient.common.serialization.DeserializingMessage;
import io.fluxcapacitor.javaclient.tracking.handling.HandlerInterceptor;
import io.fluxcapacitor.javaclient.tracking.metrics.CompleteMessageEvent;
import io.fluxcapacitor.javaclient.tracking.metrics.HandleMessageEvent;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HandlerMonitor
implements HandlerInterceptor {
    private static final Logger log = LoggerFactory.getLogger(HandlerMonitor.class);

    @Override
    public Function<DeserializingMessage, Object> interceptHandling(Function<DeserializingMessage, Object> function, Handler<DeserializingMessage> handler, String consumer) {
        return message -> {
            Instant start = Instant.now();
            try {
                Object result = function.apply((DeserializingMessage)message);
                this.publishMetrics(handler, consumer, (DeserializingMessage)message, false, start, result);
                return result;
            }
            catch (Throwable e) {
                this.publishMetrics(handler, consumer, (DeserializingMessage)message, true, start, e);
                throw e;
            }
        };
    }

    protected void publishMetrics(Handler<DeserializingMessage> handler, String consumer, DeserializingMessage message, boolean exceptionalResult, Instant start, Object result) {
        try {
            boolean completed = !(result instanceof CompletableFuture) || ((CompletableFuture)result).isDone();
            FluxCapacitor.publishMetrics(new HandleMessageEvent(FluxCapacitor.get().client().name(), FluxCapacitor.get().client().id(), consumer, handler.getTarget().getClass().getSimpleName(), message.getSerializedObject().getIndex(), message.getPayloadClass().getSimpleName(), exceptionalResult, start.until(Instant.now(), ChronoUnit.NANOS), completed));
            if (!completed) {
                ((CompletionStage)result).whenComplete((r, e) -> {
                    DeserializingMessage current = DeserializingMessage.getCurrent();
                    try {
                        DeserializingMessage.setCurrent(message);
                        FluxCapacitor.publishMetrics(new CompleteMessageEvent(FluxCapacitor.get().client().name(), FluxCapacitor.get().client().id(), consumer, handler.getTarget().getClass().getSimpleName(), message.getSerializedObject().getIndex(), message.getPayloadClass().getSimpleName(), e != null, start.until(Instant.now(), ChronoUnit.NANOS)));
                    }
                    finally {
                        DeserializingMessage.setCurrent(current);
                    }
                });
            }
        }
        catch (Exception e2) {
            log.error("Failed to publish handler metrics", (Throwable)e2);
        }
    }
}

