/*
 * Decompiled with CFR 0.152.
 */
package io.fluxcapacitor.javaclient.modeling;

import io.fluxcapacitor.common.api.Metadata;
import io.fluxcapacitor.javaclient.common.Message;
import io.fluxcapacitor.javaclient.modeling.DefaultLegalCheck;
import java.time.Instant;
import java.util.function.Function;
import java.util.function.Predicate;

public interface Aggregate<T> {
    public static final String AGGREGATE_ID_METADATA_KEY = "$aggregateId";
    public static final String AGGREGATE_TYPE_METADATA_KEY = "$aggregateType";

    public T get();

    public String lastEventId();

    public Instant timestamp();

    public Aggregate<T> apply(Message var1);

    default public Aggregate<T> apply(Object event) {
        return this.apply(new Message(event));
    }

    default public Aggregate<T> apply(Object event, Metadata metadata) {
        return this.apply(new Message(event, metadata));
    }

    default public Aggregate<T> apply(Function<T, Message> eventFunction) {
        return this.apply(eventFunction.apply(this.get()));
    }

    default public <E extends Exception> Aggregate<T> assertLegal(Object command) throws E {
        DefaultLegalCheck.assertLegal(command, this.get());
        return this;
    }

    default public <E extends Exception> Aggregate<T> assertThat(Validator<T, E> validator) throws E {
        validator.validate(this.get());
        return this;
    }

    default public <E extends Exception> Aggregate<T> ensure(Predicate<T> check, Function<T, E> errorProvider) throws E {
        if (!check.test(this.get())) {
            throw (Exception)errorProvider.apply(this.get());
        }
        return this;
    }

    @FunctionalInterface
    public static interface Validator<T, E extends Exception> {
        public void validate(T var1) throws E;
    }
}

