/*
 * Decompiled with CFR 0.152.
 */
package io.fluxcapacitor.javaclient.modeling;

import io.fluxcapacitor.javaclient.modeling.Aggregate;
import io.fluxcapacitor.javaclient.modeling.AggregateRepository;
import java.beans.ConstructorProperties;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;

public class CompositeAggregateRepository
implements AggregateRepository {
    private final List<AggregateRepository> delegates;

    public CompositeAggregateRepository(AggregateRepository ... delegates) {
        this(Arrays.asList(delegates));
    }

    @Override
    public boolean supports(Class<?> aggregateType) {
        return this.delegates.stream().anyMatch(r -> r.supports(aggregateType));
    }

    @Override
    public <T> Aggregate<T> load(String aggregateId, Class<T> aggregateType, boolean onlyCached) {
        Optional<AggregateRepository> delegate = this.delegates.stream().filter(r -> r.supports(aggregateType)).findFirst();
        if (delegate.isPresent()) {
            return delegate.get().load(aggregateId, aggregateType, onlyCached);
        }
        throw new UnsupportedOperationException("Could not a find a suitable aggregate repository for aggregate of type: " + aggregateType);
    }

    @ConstructorProperties(value={"delegates"})
    public CompositeAggregateRepository(List<AggregateRepository> delegates) {
        this.delegates = delegates;
    }
}

