/*
 * Decompiled with CFR 0.152.
 */
package io.fluxcapacitor.javaclient.modeling;

import io.fluxcapacitor.common.handling.HandlerConfiguration;
import io.fluxcapacitor.common.handling.HandlerInspector;
import io.fluxcapacitor.common.handling.HandlerInvoker;
import io.fluxcapacitor.javaclient.modeling.Aggregate;
import io.fluxcapacitor.javaclient.modeling.AssertLegal;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;

public class DefaultLegalCheck {
    private static Map<Class<?>, HandlerInvoker<Object>> invokerCache = new ConcurrentHashMap();

    public static <E extends Exception> void assertLegal(Object commandOrQuery, Object aggregate) throws E {
        HandlerInvoker invoker = invokerCache.computeIfAbsent(commandOrQuery.getClass(), type -> HandlerInspector.inspect(commandOrQuery.getClass(), AssertLegal.class, Collections.singletonList(p -> v -> v instanceof Aggregate ? ((Aggregate)v).get() : v), (HandlerConfiguration)HandlerConfiguration.builder().failOnMissingMethods(false).invokeMultipleMethods(true).build()));
        if (invoker.canHandle(commandOrQuery, aggregate)) {
            invoker.invoke(commandOrQuery, aggregate);
        }
    }

    public static <E extends Exception> Optional<E> checkLegality(Object commandOrQuery, Object aggregate) {
        try {
            DefaultLegalCheck.assertLegal(commandOrQuery, aggregate);
        }
        catch (Exception e) {
            return Optional.of(e);
        }
        return Optional.empty();
    }

    public static boolean isLegal(Object commandOrQuery, Object aggregate) {
        return !DefaultLegalCheck.checkLegality(commandOrQuery, aggregate).isPresent();
    }
}

