/*
 * Decompiled with CFR 0.152.
 */
package io.fluxcapacitor.javaclient.persisting.eventsourcing;

import io.fluxcapacitor.common.handling.HandlerConfiguration;
import io.fluxcapacitor.common.handling.HandlerInspector;
import io.fluxcapacitor.common.handling.HandlerInvoker;
import io.fluxcapacitor.common.handling.HandlerNotFoundException;
import io.fluxcapacitor.common.handling.ParameterResolver;
import io.fluxcapacitor.javaclient.common.serialization.DeserializingMessage;
import io.fluxcapacitor.javaclient.persisting.eventsourcing.ApplyEvent;
import io.fluxcapacitor.javaclient.persisting.eventsourcing.EventSourcingHandler;
import java.util.List;

public class AnnotatedEventSourcingHandler<T>
implements EventSourcingHandler<T> {
    private final Class<T> handlerType;
    private final HandlerInvoker<DeserializingMessage> invoker;

    public AnnotatedEventSourcingHandler(Class<T> handlerType) {
        this(handlerType, DeserializingMessage.defaultParameterResolvers);
    }

    public AnnotatedEventSourcingHandler(Class<T> handlerType, List<ParameterResolver<? super DeserializingMessage>> parameterResolvers) {
        this.handlerType = handlerType;
        this.invoker = HandlerInspector.inspect(handlerType, ApplyEvent.class, parameterResolvers, (HandlerConfiguration)HandlerConfiguration.defaultHandlerConfiguration());
    }

    @Override
    public T invoke(T target, DeserializingMessage message) {
        Object result;
        try {
            result = this.invoker.invoke(target, (Object)message);
        }
        catch (HandlerNotFoundException e) {
            if (target == null) {
                throw e;
            }
            return target;
        }
        if (target == null) {
            return this.handlerType.cast(result);
        }
        if (this.handlerType.isInstance(result)) {
            return this.handlerType.cast(result);
        }
        if (result == null && this.invoker.expectResult(target, (Object)message)) {
            return null;
        }
        return target;
    }

    @Override
    public boolean canHandle(T target, DeserializingMessage message) {
        return this.invoker.canHandle(target, (Object)message);
    }
}

