/*
 * Decompiled with CFR 0.152.
 */
package io.fluxcapacitor.javaclient.persisting.eventsourcing;

import io.fluxcapacitor.common.ConsistentHashing;
import io.fluxcapacitor.common.MessageType;
import io.fluxcapacitor.common.Registration;
import io.fluxcapacitor.common.api.SerializedMessage;
import io.fluxcapacitor.common.handling.Handler;
import io.fluxcapacitor.javaclient.common.Message;
import io.fluxcapacitor.javaclient.common.serialization.DeserializingMessage;
import io.fluxcapacitor.javaclient.persisting.eventsourcing.EventSourcingException;
import io.fluxcapacitor.javaclient.persisting.eventsourcing.EventStore;
import io.fluxcapacitor.javaclient.persisting.eventsourcing.EventStoreSerializer;
import io.fluxcapacitor.javaclient.persisting.eventsourcing.client.EventStoreClient;
import io.fluxcapacitor.javaclient.tracking.handling.HandlerFactory;
import java.beans.ConstructorProperties;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.stream.Stream;

public class DefaultEventStore
implements EventStore {
    private final EventStoreClient client;
    private final EventStoreSerializer serializer;
    private final HandlerFactory handlerFactory;
    private final List<Handler<DeserializingMessage>> localHandlers = new CopyOnWriteArrayList<Handler<DeserializingMessage>>();

    @Override
    public void storeDomainEvents(String aggregateId, String domain, long lastSequenceNumber, List<?> events) {
        try {
            int segment = ConsistentHashing.computeSegment((String)aggregateId);
            ArrayList<SerializedMessage> messages = new ArrayList<SerializedMessage>(events.size());
            events.forEach(e -> {
                DeserializingMessage deserializingMessage;
                if (e instanceof DeserializingMessage) {
                    deserializingMessage = (DeserializingMessage)e;
                } else {
                    Message message = e instanceof Message ? (Message)e : new Message(e);
                    deserializingMessage = new DeserializingMessage(this.serializer.serialize(message), message::getPayload, MessageType.EVENT);
                }
                messages.add(deserializingMessage.getSerializedObject().withSegment(Integer.valueOf(segment)));
                this.tryHandleLocally(deserializingMessage);
            });
            this.client.storeEvents(aggregateId, domain, lastSequenceNumber, messages).await();
        }
        catch (Exception e2) {
            throw new EventSourcingException(String.format("Failed to store events %s for aggregate %s", events, aggregateId), e2);
        }
    }

    @Override
    public Stream<DeserializingMessage> getDomainEvents(String aggregateId, long lastSequenceNumber) {
        try {
            return this.serializer.deserializeDomainEvents(this.client.getEvents(aggregateId, lastSequenceNumber));
        }
        catch (Exception e) {
            throw new EventSourcingException(String.format("Failed to obtain domain events for aggregate %s", aggregateId), e);
        }
    }

    @Override
    public Registration registerLocalHandler(Object target) {
        Optional<Handler<DeserializingMessage>> handler = this.handlerFactory.createHandler(target);
        handler.ifPresent(this.localHandlers::add);
        return () -> handler.ifPresent(this.localHandlers::remove);
    }

    protected void tryHandleLocally(DeserializingMessage deserializingMessage) {
        if (!this.localHandlers.isEmpty()) {
            deserializingMessage.run(m -> this.localHandlers.stream().filter(handler -> handler.canHandle(m)).forEach(handler -> handler.invoke(m)));
        }
    }

    @ConstructorProperties(value={"client", "serializer", "handlerFactory"})
    public DefaultEventStore(EventStoreClient client, EventStoreSerializer serializer, HandlerFactory handlerFactory) {
        this.client = client;
        this.serializer = serializer;
        this.handlerFactory = handlerFactory;
    }
}

