/*
 * Decompiled with CFR 0.152.
 */
package io.fluxcapacitor.javaclient.persisting.eventsourcing;

import io.fluxcapacitor.common.Guarantee;
import io.fluxcapacitor.javaclient.common.serialization.SerializationException;
import io.fluxcapacitor.javaclient.common.serialization.Serializer;
import io.fluxcapacitor.javaclient.persisting.eventsourcing.EventSourcedModel;
import io.fluxcapacitor.javaclient.persisting.eventsourcing.EventSourcingException;
import io.fluxcapacitor.javaclient.persisting.eventsourcing.SnapshotRepository;
import io.fluxcapacitor.javaclient.persisting.keyvalue.client.KeyValueClient;
import java.beans.ConstructorProperties;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultSnapshotRepository
implements SnapshotRepository {
    private static final Logger log = LoggerFactory.getLogger(DefaultSnapshotRepository.class);
    private final KeyValueClient keyValueClient;
    private final Serializer serializer;

    @Override
    public void storeSnapshot(EventSourcedModel<?> snapshot) {
        try {
            this.keyValueClient.putValue(this.snapshotKey(snapshot.id()), this.serializer.serialize(snapshot), Guarantee.SENT);
        }
        catch (Exception e) {
            throw new EventSourcingException(String.format("Failed to store a snapshot: %s", snapshot), e);
        }
    }

    @Override
    public <T> Optional<EventSourcedModel<T>> getSnapshot(String aggregateId) {
        try {
            return Optional.ofNullable(this.keyValueClient.getValue(this.snapshotKey(aggregateId))).map(this.serializer::deserialize);
        }
        catch (SerializationException e) {
            log.warn("Failed to deserialize snapshot for {}. Deleting snapshot.", (Object)aggregateId, (Object)e);
            this.deleteSnapshot(aggregateId);
            return Optional.empty();
        }
        catch (Exception e) {
            throw new EventSourcingException(String.format("Failed to obtain snapshot for aggregate %s", aggregateId), e);
        }
    }

    @Override
    public void deleteSnapshot(String aggregateId) {
        try {
            this.keyValueClient.deleteValue(this.snapshotKey(aggregateId));
        }
        catch (Exception e) {
            throw new EventSourcingException(String.format("Failed to delete snapshot for aggregate %s", aggregateId), e);
        }
    }

    protected String snapshotKey(String aggregateId) {
        return "$snapshot_" + aggregateId;
    }

    @ConstructorProperties(value={"keyValueClient", "serializer"})
    public DefaultSnapshotRepository(KeyValueClient keyValueClient, Serializer serializer) {
        this.keyValueClient = keyValueClient;
        this.serializer = serializer;
    }
}

