/*
 * Decompiled with CFR 0.152.
 */
package io.fluxcapacitor.javaclient.persisting.eventsourcing;

import io.fluxcapacitor.javaclient.common.Message;
import io.fluxcapacitor.javaclient.modeling.Aggregate;
import java.beans.ConstructorProperties;
import java.time.Instant;

public final class EventSourcedModel<T>
implements Aggregate<T> {
    private final String id;
    private final long sequenceNumber;
    private final String lastEventId;
    private final Instant timestamp;
    private final T model;

    @Override
    public T get() {
        return this.model;
    }

    @Override
    public Aggregate<T> apply(Message eventMessage) {
        throw new UnsupportedOperationException(String.format("Not allowed to apply a %s. The model is readonly.", eventMessage));
    }

    private static <T> long $default$sequenceNumber() {
        return -1L;
    }

    private static <T> Instant $default$timestamp() {
        return Instant.now();
    }

    @ConstructorProperties(value={"id", "sequenceNumber", "lastEventId", "timestamp", "model"})
    EventSourcedModel(String id, long sequenceNumber, String lastEventId, Instant timestamp, T model) {
        this.id = id;
        this.sequenceNumber = sequenceNumber;
        this.lastEventId = lastEventId;
        this.timestamp = timestamp;
        this.model = model;
    }

    public static <T> EventSourcedModelBuilder<T> builder() {
        return new EventSourcedModelBuilder();
    }

    public EventSourcedModelBuilder<T> toBuilder() {
        return new EventSourcedModelBuilder().id(this.id).sequenceNumber(this.sequenceNumber).lastEventId(this.lastEventId).timestamp(this.timestamp).model(this.model);
    }

    public String id() {
        return this.id;
    }

    public long sequenceNumber() {
        return this.sequenceNumber;
    }

    @Override
    public String lastEventId() {
        return this.lastEventId;
    }

    @Override
    public Instant timestamp() {
        return this.timestamp;
    }

    public T model() {
        return this.model;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof EventSourcedModel)) {
            return false;
        }
        EventSourcedModel other = (EventSourcedModel)o;
        String this$id = this.id();
        String other$id = other.id();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        if (this.sequenceNumber() != other.sequenceNumber()) {
            return false;
        }
        String this$lastEventId = this.lastEventId();
        String other$lastEventId = other.lastEventId();
        if (this$lastEventId == null ? other$lastEventId != null : !this$lastEventId.equals(other$lastEventId)) {
            return false;
        }
        Instant this$timestamp = this.timestamp();
        Instant other$timestamp = other.timestamp();
        if (this$timestamp == null ? other$timestamp != null : !((Object)this$timestamp).equals(other$timestamp)) {
            return false;
        }
        T this$model = this.model();
        T other$model = other.model();
        return !(this$model == null ? other$model != null : !this$model.equals(other$model));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $id = this.id();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        long $sequenceNumber = this.sequenceNumber();
        result = result * 59 + (int)($sequenceNumber >>> 32 ^ $sequenceNumber);
        String $lastEventId = this.lastEventId();
        result = result * 59 + ($lastEventId == null ? 43 : $lastEventId.hashCode());
        Instant $timestamp = this.timestamp();
        result = result * 59 + ($timestamp == null ? 43 : ((Object)$timestamp).hashCode());
        T $model = this.model();
        result = result * 59 + ($model == null ? 43 : $model.hashCode());
        return result;
    }

    public String toString() {
        return "EventSourcedModel(id=" + this.id() + ", sequenceNumber=" + this.sequenceNumber() + ", lastEventId=" + this.lastEventId() + ", timestamp=" + this.timestamp() + ", model=" + this.model() + ")";
    }

    public static class EventSourcedModelBuilder<T> {
        private String id;
        private boolean sequenceNumber$set;
        private long sequenceNumber$value;
        private String lastEventId;
        private boolean timestamp$set;
        private Instant timestamp$value;
        private T model;

        EventSourcedModelBuilder() {
        }

        public EventSourcedModelBuilder<T> id(String id) {
            this.id = id;
            return this;
        }

        public EventSourcedModelBuilder<T> sequenceNumber(long sequenceNumber) {
            this.sequenceNumber$value = sequenceNumber;
            this.sequenceNumber$set = true;
            return this;
        }

        public EventSourcedModelBuilder<T> lastEventId(String lastEventId) {
            this.lastEventId = lastEventId;
            return this;
        }

        public EventSourcedModelBuilder<T> timestamp(Instant timestamp) {
            this.timestamp$value = timestamp;
            this.timestamp$set = true;
            return this;
        }

        public EventSourcedModelBuilder<T> model(T model) {
            this.model = model;
            return this;
        }

        public EventSourcedModel<T> build() {
            long sequenceNumber$value = this.sequenceNumber$value;
            if (!this.sequenceNumber$set) {
                sequenceNumber$value = EventSourcedModel.$default$sequenceNumber();
            }
            Instant timestamp$value = this.timestamp$value;
            if (!this.timestamp$set) {
                timestamp$value = EventSourcedModel.$default$timestamp();
            }
            return new EventSourcedModel<T>(this.id, sequenceNumber$value, this.lastEventId, timestamp$value, this.model);
        }

        public String toString() {
            return "EventSourcedModel.EventSourcedModelBuilder(id=" + this.id + ", sequenceNumber$value=" + this.sequenceNumber$value + ", lastEventId=" + this.lastEventId + ", timestamp$value=" + this.timestamp$value + ", model=" + this.model + ")";
        }
    }
}

