/*
 * Decompiled with CFR 0.152.
 */
package io.fluxcapacitor.javaclient.persisting.keyvalue.client;

import io.fluxcapacitor.common.Awaitable;
import io.fluxcapacitor.common.Backlog;
import io.fluxcapacitor.common.Guarantee;
import io.fluxcapacitor.common.api.Data;
import io.fluxcapacitor.common.api.Request;
import io.fluxcapacitor.common.api.keyvalue.DeleteValue;
import io.fluxcapacitor.common.api.keyvalue.GetValue;
import io.fluxcapacitor.common.api.keyvalue.GetValueResult;
import io.fluxcapacitor.common.api.keyvalue.KeyValuePair;
import io.fluxcapacitor.common.api.keyvalue.StoreValues;
import io.fluxcapacitor.common.api.keyvalue.StoreValuesAndWait;
import io.fluxcapacitor.javaclient.common.websocket.AbstractWebsocketClient;
import io.fluxcapacitor.javaclient.configuration.client.WebSocketClient;
import io.fluxcapacitor.javaclient.persisting.keyvalue.client.KeyValueClient;
import java.net.URI;
import java.util.Collections;
import java.util.List;
import javax.websocket.ClientEndpoint;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ClientEndpoint
public class WebsocketKeyValueClient
extends AbstractWebsocketClient
implements KeyValueClient {
    private static final Logger log = LoggerFactory.getLogger(WebsocketKeyValueClient.class);
    private final Backlog<KeyValuePair> backlog = new Backlog(this::storeValues);

    public WebsocketKeyValueClient(String endPointUrl, WebSocketClient.Properties properties) {
        this(URI.create(endPointUrl), properties);
    }

    public WebsocketKeyValueClient(URI endpointUri, WebSocketClient.Properties properties) {
        super(endpointUri, properties);
    }

    protected Awaitable storeValues(List<KeyValuePair> keyValuePairs) {
        return this.send(new StoreValues(keyValuePairs));
    }

    @Override
    public Awaitable putValue(String key, Data<byte[]> value, Guarantee guarantee) {
        switch (guarantee) {
            case NONE: {
                this.backlog.add((Object[])new KeyValuePair[]{new KeyValuePair(key, value)});
                return Awaitable.ready();
            }
            case SENT: {
                return this.backlog.add((Object[])new KeyValuePair[]{new KeyValuePair(key, value)});
            }
            case STORED: {
                this.sendRequestAndWait((Request)new StoreValuesAndWait(Collections.singletonList(new KeyValuePair(key, value))));
                return Awaitable.ready();
            }
        }
        throw new UnsupportedOperationException("Unrecognized guarantee: " + guarantee);
    }

    @Override
    public Data<byte[]> getValue(String key) {
        GetValueResult result = (GetValueResult)this.sendRequestAndWait((Request)new GetValue(key));
        return result.getValue();
    }

    @Override
    public Awaitable deleteValue(String key) {
        return this.send(new DeleteValue(key));
    }
}

