/*
 * Decompiled with CFR 0.152.
 */
package io.fluxcapacitor.javaclient.publishing;

import io.fluxcapacitor.common.MessageType;
import io.fluxcapacitor.common.Registration;
import io.fluxcapacitor.common.api.SerializedMessage;
import io.fluxcapacitor.common.handling.Handler;
import io.fluxcapacitor.javaclient.common.Message;
import io.fluxcapacitor.javaclient.common.serialization.DeserializingMessage;
import io.fluxcapacitor.javaclient.common.serialization.MessageSerializer;
import io.fluxcapacitor.javaclient.publishing.EventGateway;
import io.fluxcapacitor.javaclient.publishing.GatewayException;
import io.fluxcapacitor.javaclient.publishing.client.GatewayClient;
import io.fluxcapacitor.javaclient.tracking.handling.HandlerFactory;
import java.beans.ConstructorProperties;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CopyOnWriteArrayList;

public class DefaultEventGateway
implements EventGateway {
    private final GatewayClient gatewayClient;
    private final MessageSerializer serializer;
    private final HandlerFactory handlerFactory;
    private final List<Handler<DeserializingMessage>> localHandlers = new CopyOnWriteArrayList<Handler<DeserializingMessage>>();

    @Override
    public void publish(Message message) {
        SerializedMessage serializedMessage = this.serializer.serialize(message);
        this.tryHandleLocally(message.getPayload(), serializedMessage);
        try {
            this.gatewayClient.send(serializedMessage);
        }
        catch (Exception e) {
            throw new GatewayException(String.format("Failed to send and forget %s", message.getPayload().toString()), e);
        }
    }

    @Override
    public Registration registerLocalHandler(Object target) {
        Optional<Handler<DeserializingMessage>> handler = this.handlerFactory.createHandler(target);
        handler.ifPresent(this.localHandlers::add);
        return () -> handler.ifPresent(this.localHandlers::remove);
    }

    protected void tryHandleLocally(Object payload, SerializedMessage serializedMessage) {
        if (!this.localHandlers.isEmpty()) {
            new DeserializingMessage(serializedMessage, () -> payload, MessageType.EVENT).run(m -> this.localHandlers.stream().filter(handler -> handler.canHandle(m)).forEach(handler -> handler.invoke(m)));
        }
    }

    @ConstructorProperties(value={"gatewayClient", "serializer", "handlerFactory"})
    public DefaultEventGateway(GatewayClient gatewayClient, MessageSerializer serializer, HandlerFactory handlerFactory) {
        this.gatewayClient = gatewayClient;
        this.serializer = serializer;
        this.handlerFactory = handlerFactory;
    }
}

