/*
 * Decompiled with CFR 0.152.
 */
package io.fluxcapacitor.javaclient.publishing.correlation;

import io.fluxcapacitor.common.MessageType;
import io.fluxcapacitor.common.api.SerializedMessage;
import io.fluxcapacitor.common.reflection.ReflectionUtils;
import io.fluxcapacitor.javaclient.common.Message;
import io.fluxcapacitor.javaclient.common.serialization.DeserializingMessage;
import io.fluxcapacitor.javaclient.configuration.client.Client;
import io.fluxcapacitor.javaclient.publishing.DispatchInterceptor;
import io.fluxcapacitor.javaclient.publishing.routing.RoutingKey;
import java.beans.ConstructorProperties;
import java.util.HashMap;
import java.util.function.Function;

public class CorrelatingInterceptor
implements DispatchInterceptor {
    private final Client client;
    private final String clientId;
    private final String correlationId;
    private final String traceId;
    private final String trigger;
    private final String triggerRoutingKey;

    public CorrelatingInterceptor(Client client) {
        this(client, "$clientId", "$correlationId", "$traceId", "$trigger", "$triggerRoutingKey");
    }

    @Override
    public Function<Message, SerializedMessage> interceptDispatch(Function<Message, SerializedMessage> function, MessageType messageType) {
        return message -> {
            HashMap<String, String> result = new HashMap<String, String>();
            result.put(this.clientId, this.client.id());
            DeserializingMessage currentMessage = DeserializingMessage.getCurrent();
            if (currentMessage != null) {
                Long index = currentMessage.getSerializedObject().getIndex();
                if (index != null) {
                    String correlationId = index.toString();
                    result.put(this.correlationId, correlationId);
                    result.put(this.traceId, currentMessage.getMetadata().getOrDefault((Object)this.traceId, correlationId));
                }
                result.put(this.trigger, currentMessage.getSerializedObject().getData().getType());
                if (currentMessage.isDeserialized()) {
                    ReflectionUtils.getAnnotatedPropertyValue(currentMessage.getPayload(), RoutingKey.class).map(Object::toString).ifPresent(v -> result.put(this.triggerRoutingKey, (String)v));
                }
            }
            message.getMetadata().putAll(result);
            return (SerializedMessage)function.apply((Message)message);
        };
    }

    @ConstructorProperties(value={"client", "clientId", "correlationId", "traceId", "trigger", "triggerRoutingKey"})
    public CorrelatingInterceptor(Client client, String clientId, String correlationId, String traceId, String trigger, String triggerRoutingKey) {
        this.client = client;
        this.clientId = clientId;
        this.correlationId = correlationId;
        this.traceId = traceId;
        this.trigger = trigger;
        this.triggerRoutingKey = triggerRoutingKey;
    }
}

